/*
 * Decompiled with CFR 0.152.
 */
package org.jxmpp.jid.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.DomainFullJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.EntityJid;
import org.jxmpp.jid.FullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Localpart;
import org.jxmpp.jid.parts.Resourcepart;

public abstract class AbstractJid
implements Jid {
    private static final long serialVersionUID = 1L;
    protected String cache;
    private transient String internalizedCache;
    private transient String urlEncodedCache;

    @Override
    public final boolean isEntityJid() {
        return this.isEntityBareJid() || this.isEntityFullJid();
    }

    @Override
    public final boolean isEntityBareJid() {
        return this instanceof EntityBareJid;
    }

    @Override
    public final boolean isEntityFullJid() {
        return this instanceof EntityFullJid;
    }

    @Override
    public final boolean isDomainBareJid() {
        return this instanceof DomainBareJid;
    }

    @Override
    public final boolean isDomainFullJid() {
        return this instanceof DomainFullJid;
    }

    @Override
    public abstract boolean hasNoResource();

    @Override
    public final boolean hasResource() {
        return this instanceof FullJid;
    }

    @Override
    public final boolean hasLocalpart() {
        return this instanceof EntityJid;
    }

    @Override
    public final <T extends Jid> T downcast(Class<T> jidClass) {
        return (T)((Jid)jidClass.cast(this));
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start2, int end) {
        return this.toString().subSequence(start2, end);
    }

    @Override
    public final EntityBareJid asEntityBareJidOrThrow() {
        EntityBareJid entityBareJid = this.asEntityBareJidIfPossible();
        if (entityBareJid == null) {
            this.throwIse("can not be converted to EntityBareJid");
        }
        return entityBareJid;
    }

    @Override
    public EntityFullJid asEntityFullJidOrThrow() {
        EntityFullJid entityFullJid = this.asEntityFullJidIfPossible();
        if (entityFullJid == null) {
            this.throwIse("can not be converted to EntityFullJid");
        }
        return entityFullJid;
    }

    @Override
    public EntityJid asEntityJidOrThrow() {
        EntityJid entityJid = this.asEntityJidIfPossible();
        if (entityJid == null) {
            this.throwIse("can not be converted to EntityJid");
        }
        return entityJid;
    }

    @Override
    public EntityFullJid asFullJidOrThrow() {
        EntityFullJid entityFullJid = this.asEntityFullJidIfPossible();
        if (entityFullJid == null) {
            this.throwIse("can not be converted to EntityBareJid");
        }
        return entityFullJid;
    }

    @Override
    public DomainFullJid asDomainFullJidOrThrow() {
        DomainFullJid domainFullJid = this.asDomainFullJidIfPossible();
        if (domainFullJid == null) {
            this.throwIse("can not be converted to DomainFullJid");
        }
        return domainFullJid;
    }

    @Override
    public abstract Resourcepart getResourceOrNull();

    @Override
    public final Resourcepart getResourceOrEmpty() {
        Resourcepart resourcepart = this.getResourceOrNull();
        if (resourcepart == null) {
            return Resourcepart.EMPTY;
        }
        return resourcepart;
    }

    @Override
    public final Resourcepart getResourceOrThrow() {
        Resourcepart resourcepart = this.getResourceOrNull();
        if (resourcepart == null) {
            this.throwIse("has no resourcepart");
        }
        return resourcepart;
    }

    @Override
    public abstract Localpart getLocalpartOrNull();

    @Override
    public final Localpart getLocalpartOrThrow() {
        Localpart localpart = this.getLocalpartOrNull();
        if (localpart == null) {
            this.throwIse("has no localpart");
        }
        return localpart;
    }

    @Override
    public final boolean isParentOf(Jid jid) {
        EntityFullJid fullJid = jid.asEntityFullJidIfPossible();
        if (fullJid != null) {
            return this.isParentOf(fullJid);
        }
        EntityBareJid bareJid = jid.asEntityBareJidIfPossible();
        if (bareJid != null) {
            return this.isParentOf(bareJid);
        }
        DomainFullJid domainFullJid = jid.asDomainFullJidIfPossible();
        if (domainFullJid != null) {
            return this.isParentOf(domainFullJid);
        }
        return this.isParentOf(jid.asDomainBareJid());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof CharSequence) {
            return this.equals((CharSequence)other);
        }
        return false;
    }

    @Override
    public final boolean equals(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        return this.equals(charSequence.toString());
    }

    @Override
    public final boolean equals(String string) {
        return this.toString().equals(string);
    }

    @Override
    public final int compareTo(Jid other) {
        String otherString = other.toString();
        String myString = this.toString();
        return myString.compareTo(otherString);
    }

    @Override
    public final String intern() {
        if (this.internalizedCache == null) {
            this.cache = this.internalizedCache = this.toString().intern();
        }
        return this.internalizedCache;
    }

    @Override
    public final String asUrlEncodedString() {
        if (this.urlEncodedCache == null) {
            String string = this.toString();
            try {
                this.urlEncodedCache = URLEncoder.encode(string, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return this.urlEncodedCache;
    }

    private void throwIse(String message) {
        String exceptionMessage = "The JID '" + this + "' " + message;
        throw new IllegalStateException(exceptionMessage);
    }

    static <O> O requireNonNull(O object, String message) {
        if (object != null) {
            return object;
        }
        throw new IllegalArgumentException(message);
    }
}

