/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.compression;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionConfiguration;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.compress.packet.Compress;
import org.jivesoftware.smack.compress.packet.Compressed;
import org.jivesoftware.smack.compress.packet.Failure;
import org.jivesoftware.smack.compression.CompressionModuleDescriptor;
import org.jivesoftware.smack.compression.XmppCompressionFactory;
import org.jivesoftware.smack.compression.XmppCompressionManager;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;

public class CompressionModule
extends ModularXmppClientToServerConnectionModule<CompressionModuleDescriptor> {
    protected CompressionModule(CompressionModuleDescriptor moduleDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        super(moduleDescriptor, connectionInternal);
    }

    public CompressionState constructCompressionState(CompressionStateDescriptor compressionStateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
        return new CompressionState(compressionStateDescriptor, connectionInternal);
    }

    public static final class CompressionTransitionSuccessResult
    extends StateTransitionResult.Success {
        private final String compressionMethod;

        private CompressionTransitionSuccessResult(String compressionMethod) {
            super(compressionMethod + " compression enabled");
            this.compressionMethod = compressionMethod;
        }

        public String getCompressionMethod() {
            return this.compressionMethod;
        }
    }

    private static final class CompressionState
    extends State {
        private XmppCompressionFactory selectedCompressionFactory;
        private XmppInputOutputFilter usedXmppInputOutputCompressionFitler;

        private CompressionState(StateDescriptor stateDescriptor, ModularXmppClientToServerConnectionInternal connectionInternal) {
            super(stateDescriptor, connectionInternal);
        }

        @Override
        public StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            ModularXmppClientToServerConnectionConfiguration config = this.connectionInternal.connection.getConfiguration();
            if (!config.isCompressionEnabled()) {
                return new StateTransitionResult.TransitionImpossibleReason("Stream compression disabled by connection configuration");
            }
            Compress.Feature compressFeature = this.connectionInternal.connection.getFeature(Compress.Feature.class);
            if (compressFeature == null) {
                return new StateTransitionResult.TransitionImpossibleReason("Stream compression not supported or enabled by service");
            }
            this.selectedCompressionFactory = XmppCompressionManager.getBestFactory(compressFeature);
            if (this.selectedCompressionFactory == null) {
                return new StateTransitionResult.TransitionImpossibleReason("No matching compression factory for " + compressFeature.getMethods());
            }
            this.usedXmppInputOutputCompressionFitler = this.selectedCompressionFactory.fabricate(config);
            return null;
        }

        @Override
        public StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) throws InterruptedException, SmackException, XMPPException {
            String compressionMethod = this.selectedCompressionFactory.getCompressionMethod();
            this.connectionInternal.sendAndWaitForResponse(new Compress(compressionMethod), Compressed.class, Failure.class);
            this.connectionInternal.addXmppInputOutputFilter(this.usedXmppInputOutputCompressionFitler);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("server stream features after compression enabled");
            this.connectionInternal.setCompressionEnabled(true);
            return new CompressionTransitionSuccessResult(compressionMethod);
        }

        @Override
        public void resetState() {
            this.selectedCompressionFactory = null;
            this.usedXmppInputOutputCompressionFitler = null;
            this.connectionInternal.setCompressionEnabled(false);
        }
    }

    public static final class CompressionStateDescriptor
    extends StateDescriptor {
        private CompressionStateDescriptor() {
            super(CompressionState.class, 138);
            this.addPredeccessor(ModularXmppClientToServerConnection.AuthenticatedButUnboundStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.AuthenticatedButUnboundStateDescriptor.class);
            this.declarePrecedenceOver(ModularXmppClientToServerConnection.ResourceBindingStateDescriptor.class);
        }

        @Override
        protected CompressionState constructState(ModularXmppClientToServerConnectionInternal connectionInternal) {
            CompressionModule compressionModule = (CompressionModule)connectionInternal.connection.getConnectionModuleFor(CompressionModuleDescriptor.class);
            return compressionModule.constructCompressionState(this, connectionInternal);
        }
    }
}

