/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging;

import java.util.logging.Level;
import org.jitsi.utils.logging.Logger;

public class InstanceLogger
extends Logger {
    private final Logger loggingDelegate;
    private final Logger levelDelegate;
    private Level level = null;

    protected InstanceLogger(Logger loggingDelegate, Logger levelDelegate) {
        this.loggingDelegate = loggingDelegate;
        this.levelDelegate = levelDelegate;
    }

    @Override
    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Level getLevel() {
        return this.higher(this.higher(this.level != null ? this.level : Level.ALL, this.loggingDelegate.getLevel()), this.levelDelegate != null ? this.levelDelegate.getLevel() : Level.ALL);
    }

    @Override
    boolean isLoggable(Level level) {
        Level loggerLevel = this.getLevel();
        if (level == null || loggerLevel == Level.OFF) {
            return false;
        }
        return level.intValue() >= loggerLevel.intValue();
    }

    @Override
    public void log(Level level, Object msg) {
        if (this.isLoggable(level)) {
            this.loggingDelegate.log(level, msg != null ? msg.toString() : "null");
        }
    }

    @Override
    public void log(Level level, Object msg, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.loggingDelegate.log(level, msg != null ? msg.toString() : "null", thrown);
        }
    }

    private Level higher(Level a, Level b) {
        if (a.intValue() >= b.intValue()) {
            return a;
        }
        return b;
    }
}

