/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.VideoRtpPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH&J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000f\u001a\u00020\u0010H\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0014"}, d2={"Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "<init>", "(Lorg/jitsi/nlj/MediaSourceDesc;)V", "getSource", "()Lorg/jitsi/nlj/MediaSourceDesc;", "setSource", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "findRtpEncodingDesc", "Lorg/jitsi/nlj/RtpEncodingDesc;", "packet", "Lorg/jitsi/nlj/rtp/VideoRtpPacket;", "findRtpLayerDescs", "", "Lorg/jitsi/nlj/RtpLayerDesc;", "jitsi-media-transform"})
public abstract class VideoCodecParser {
    @NotNull
    private MediaSourceDesc source;

    public VideoCodecParser(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter(source, "source");
        this.source = source;
    }

    @NotNull
    public final MediaSourceDesc getSource() {
        return this.source;
    }

    public final void setSource(@NotNull MediaSourceDesc mediaSourceDesc) {
        Intrinsics.checkNotNullParameter(mediaSourceDesc, "<set-?>");
        this.source = mediaSourceDesc;
    }

    public abstract void parse(@NotNull PacketInfo var1);

    @Nullable
    protected final RtpEncodingDesc findRtpEncodingDesc(@NotNull VideoRtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        RtpEncodingDesc rtpEncodingDesc = this.source.findRtpEncodingDesc(packet.getSsrc());
        if (rtpEncodingDesc != null) {
            RtpEncodingDesc it = rtpEncodingDesc;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @NotNull
    protected final Collection<RtpLayerDesc> findRtpLayerDescs(@NotNull VideoRtpPacket packet) {
        Intrinsics.checkNotNullParameter(packet, "packet");
        return this.source.findRtpLayerDescs(packet);
    }
}

