/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsDHEKeyExchange;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsDHKeyExchange;
import org.bouncycastle.tls.TlsDHanonKeyExchange;
import org.bouncycastle.tls.TlsECDHEKeyExchange;
import org.bouncycastle.tls.TlsECDHKeyExchange;
import org.bouncycastle.tls.TlsECDHanonKeyExchange;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsPSKKeyExchange;
import org.bouncycastle.tls.TlsRSAKeyExchange;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSRPKeyExchange;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;

public class DefaultTlsKeyExchangeFactory
extends AbstractTlsKeyExchangeFactory {
    @Override
    public TlsKeyExchange createDHKeyExchange(int n) throws IOException {
        return new TlsDHKeyExchange(n);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeClient(int n, TlsDHGroupVerifier tlsDHGroupVerifier) throws IOException {
        return new TlsDHanonKeyExchange(n, tlsDHGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeServer(int n, TlsDHConfig tlsDHConfig) throws IOException {
        return new TlsDHanonKeyExchange(n, tlsDHConfig);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeClient(int n, TlsDHGroupVerifier tlsDHGroupVerifier) throws IOException {
        return new TlsDHEKeyExchange(n, tlsDHGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeServer(int n, TlsDHConfig tlsDHConfig) throws IOException {
        return new TlsDHEKeyExchange(n, tlsDHConfig);
    }

    @Override
    public TlsKeyExchange createECDHKeyExchange(int n) throws IOException {
        return new TlsECDHKeyExchange(n);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeClient(int n) throws IOException {
        return new TlsECDHanonKeyExchange(n);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeServer(int n, TlsECConfig tlsECConfig) throws IOException {
        return new TlsECDHanonKeyExchange(n, tlsECConfig);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeClient(int n) throws IOException {
        return new TlsECDHEKeyExchange(n);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeServer(int n, TlsECConfig tlsECConfig) throws IOException {
        return new TlsECDHEKeyExchange(n, tlsECConfig);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeClient(int n, TlsPSKIdentity tlsPSKIdentity, TlsDHGroupVerifier tlsDHGroupVerifier) throws IOException {
        return new TlsPSKKeyExchange(n, tlsPSKIdentity, tlsDHGroupVerifier);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeServer(int n, TlsPSKIdentityManager tlsPSKIdentityManager, TlsDHConfig tlsDHConfig, TlsECConfig tlsECConfig) throws IOException {
        return new TlsPSKKeyExchange(n, tlsPSKIdentityManager, tlsDHConfig, tlsECConfig);
    }

    @Override
    public TlsKeyExchange createRSAKeyExchange(int n) throws IOException {
        return new TlsRSAKeyExchange(n);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeClient(int n, TlsSRPIdentity tlsSRPIdentity, TlsSRPConfigVerifier tlsSRPConfigVerifier) throws IOException {
        return new TlsSRPKeyExchange(n, tlsSRPIdentity, tlsSRPConfigVerifier);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeServer(int n, TlsSRPLoginParameters tlsSRPLoginParameters) throws IOException {
        return new TlsSRPKeyExchange(n, tlsSRPLoginParameters);
    }
}

