/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse;

import org.bouncycastle.tls.NameType;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;

public abstract class BCSNIServerName {
    private final int nameType;
    private final byte[] encoded;

    protected BCSNIServerName(int n, byte[] byArray) {
        if (!TlsUtils.isValidUint8(n)) {
            throw new IllegalArgumentException("'nameType' should be between 0 and 255");
        }
        if (byArray == null) {
            throw new NullPointerException("'encoded' cannot be null");
        }
        this.nameType = n;
        this.encoded = TlsUtils.clone(byArray);
    }

    public final int getType() {
        return this.nameType;
    }

    public final byte[] getEncoded() {
        return TlsUtils.clone(this.encoded);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BCSNIServerName)) {
            return false;
        }
        BCSNIServerName bCSNIServerName = (BCSNIServerName)object;
        return this.nameType == bCSNIServerName.nameType && Arrays.areEqual(this.encoded, bCSNIServerName.encoded);
    }

    public int hashCode() {
        return this.nameType ^ Arrays.hashCode(this.encoded);
    }

    public String toString() {
        return "{type=" + NameType.getText((short)this.nameType) + ", value=" + Hex.toHexString(this.encoded) + "}";
    }
}

