/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.core.net.AddressResolver;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.HopImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.Router;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ViaHeader;
import javax.sip.message.Request;

public class DefaultRouter
implements Router {
    private static StackLogger logger = CommonLogger.getLogger(DefaultRouter.class);
    private SIPTransactionStack sipStack;
    private Hop defaultRoute;

    private DefaultRouter() {
    }

    public DefaultRouter(SipStack sipStack, String defaultRoute) {
        this.sipStack = (SIPTransactionStack)sipStack;
        if (defaultRoute != null) {
            try {
                this.defaultRoute = this.sipStack.getAddressResolver().resolveAddress(new HopImpl(defaultRoute));
            }
            catch (IllegalArgumentException ex) {
                logger.logError("Invalid default route specification - need host:port/transport");
                throw ex;
            }
        }
    }

    public Hop getNextHop(Request request) throws SipException {
        SIPRequest sipRequest = (SIPRequest)request;
        RequestLine requestLine = sipRequest.getRequestLine();
        if (requestLine == null) {
            return this.defaultRoute;
        }
        GenericURI requestURI = requestLine.getUri();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        RouteList routes = sipRequest.getRouteHeaders();
        if (routes != null && routes.getFirst() != null) {
            Route route = (Route)routes.getFirst();
            URI uri = route.getAddress().getURI();
            if (uri.isSipURI()) {
                SipURI sipUri = (SipURI)uri;
                if (!sipUri.hasLrParam()) {
                    this.fixStrictRouting(sipRequest);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Route post processing fixed strict routing");
                    }
                }
                Hop hop = this.createHop(sipUri, request);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("NextHop based on Route:" + hop);
                }
                return hop;
            }
            throw new SipException("First Route not a SIP URI");
        }
        if (requestURI.isSipURI() && ((SipURI)requestURI).getMAddrParam() != null) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using request URI maddr to route the request = " + hop.toString());
            }
            return hop;
        }
        if (this.defaultRoute != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using outbound proxy to route the request = " + this.defaultRoute.toString());
            }
            return this.defaultRoute;
        }
        if (requestURI.isSipURI()) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (hop != null && logger.isLoggingEnabled(32)) {
                logger.logDebug("Used request-URI for nextHop = " + hop.toString());
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("returning null hop -- loop detected");
            }
            return hop;
        }
        InternalErrorHandler.handleException("Unexpected non-sip URI", logger);
        return null;
    }

    public void fixStrictRouting(SIPRequest req) {
        RouteList routes = req.getRouteHeaders();
        Route first = (Route)routes.getFirst();
        SipUri firstUri = (SipUri)first.getAddress().getURI();
        routes.removeFirst();
        AddressImpl addr = new AddressImpl();
        addr.setAddess(req.getRequestURI());
        Route route = new Route(addr);
        routes.add(route);
        req.setRequestURI(firstUri);
        if (logger.isLoggingEnabled(32)) {
            logger.logDebug("post: fixStrictRouting" + req);
        }
    }

    protected final Hop createHop(SipURI sipUri, Request request) {
        String transport;
        String string = transport = sipUri.isSecure() ? "tls" : sipUri.getTransportParam();
        if (transport == null) {
            ViaHeader via = (ViaHeader)request.getHeader("Via");
            if (via != null) {
                transport = via.getTransport();
            }
            if (transport == null) {
                transport = "UDP";
            }
        }
        int port2 = sipUri.getPort() != -1 ? sipUri.getPort() : (transport.equalsIgnoreCase("tls") ? 5061 : 5060);
        String host = sipUri.getMAddrParam() != null ? sipUri.getMAddrParam() : sipUri.getHost();
        AddressResolver addressResolver = this.sipStack.getAddressResolver();
        return addressResolver.resolveAddress(new HopImpl(host, port2, transport));
    }

    public Hop getOutboundProxy() {
        return this.defaultRoute;
    }

    public ListIterator getNextHops(Request request) {
        try {
            LinkedList<Hop> llist = new LinkedList<Hop>();
            llist.add(this.getNextHop(request));
            return llist.listIterator();
        }
        catch (SipException ex) {
            return null;
        }
    }
}

