/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sdp;

import gov.nist.javax.sdp.MediaDescriptionImpl;
import gov.nist.javax.sdp.TimeDescriptionImpl;
import gov.nist.javax.sdp.fields.AttributeField;
import gov.nist.javax.sdp.fields.BandwidthField;
import gov.nist.javax.sdp.fields.ConnectionField;
import gov.nist.javax.sdp.fields.EmailField;
import gov.nist.javax.sdp.fields.InformationField;
import gov.nist.javax.sdp.fields.KeyField;
import gov.nist.javax.sdp.fields.MediaField;
import gov.nist.javax.sdp.fields.OriginField;
import gov.nist.javax.sdp.fields.PhoneField;
import gov.nist.javax.sdp.fields.ProtoVersionField;
import gov.nist.javax.sdp.fields.RepeatField;
import gov.nist.javax.sdp.fields.SDPField;
import gov.nist.javax.sdp.fields.SessionNameField;
import gov.nist.javax.sdp.fields.TimeField;
import gov.nist.javax.sdp.fields.URIField;
import gov.nist.javax.sdp.fields.ZoneField;
import java.text.ParseException;
import java.util.Vector;
import javax.sdp.Connection;
import javax.sdp.Info;
import javax.sdp.Key;
import javax.sdp.Origin;
import javax.sdp.SdpException;
import javax.sdp.SdpParseException;
import javax.sdp.SessionDescription;
import javax.sdp.SessionName;
import javax.sdp.URI;
import javax.sdp.Version;

public class SessionDescriptionImpl
implements SessionDescription {
    private TimeDescriptionImpl currentTimeDescription;
    private MediaDescriptionImpl currentMediaDescription;
    protected ProtoVersionField versionImpl;
    protected OriginField originImpl;
    protected SessionNameField sessionNameImpl;
    protected InformationField infoImpl;
    protected URIField uriImpl;
    protected ConnectionField connectionImpl;
    protected KeyField keyImpl;
    protected Vector timeDescriptions;
    protected Vector mediaDescriptions;
    protected Vector zoneAdjustments;
    protected Vector emailList;
    protected Vector phoneList;
    protected Vector bandwidthList;
    protected Vector attributesList;

    public SessionDescriptionImpl() {
    }

    public SessionDescriptionImpl(SessionDescription otherSessionDescription) throws SdpException {
        Vector otherMediaDescriptions;
        Vector otherAttributes;
        Vector otherBandwidths;
        Vector otherZAs;
        Vector otherPhones;
        Vector otherEmails;
        Vector otherTimeDescriptions;
        Key otherKey;
        Connection otherConnection;
        URIField otherUriField;
        Info otherInfo;
        SessionName otherSessionName;
        Origin otherOrigin;
        if (otherSessionDescription == null) {
            return;
        }
        Version otherVersion = otherSessionDescription.getVersion();
        if (otherVersion != null) {
            this.setVersion((Version)otherVersion.clone());
        }
        if ((otherOrigin = otherSessionDescription.getOrigin()) != null) {
            this.setOrigin((Origin)otherOrigin.clone());
        }
        if ((otherSessionName = otherSessionDescription.getSessionName()) != null) {
            this.setSessionName((SessionName)otherSessionName.clone());
        }
        if ((otherInfo = otherSessionDescription.getInfo()) != null) {
            this.setInfo((Info)otherInfo.clone());
        }
        if ((otherUriField = (URIField)otherSessionDescription.getURI()) != null) {
            URIField newUF = new URIField();
            newUF.setURI(otherUriField.toString());
            this.setURI(newUF);
        }
        if ((otherConnection = otherSessionDescription.getConnection()) != null) {
            this.setConnection((Connection)otherConnection.clone());
        }
        if ((otherKey = otherSessionDescription.getKey()) != null) {
            this.setKey((Key)otherKey.clone());
        }
        if ((otherTimeDescriptions = otherSessionDescription.getTimeDescriptions(false)) != null) {
            Vector<TimeDescriptionImpl> newTDs = new Vector<TimeDescriptionImpl>();
            for (TimeDescriptionImpl otherTimeDescription : otherTimeDescriptions) {
                if (otherTimeDescription == null) continue;
                TimeField otherTimeField = (TimeField)otherTimeDescription.getTime().clone();
                TimeDescriptionImpl newTD = new TimeDescriptionImpl(otherTimeField);
                Vector otherRepeatTimes = otherTimeDescription.getRepeatTimes(false);
                if (otherRepeatTimes != null) {
                    for (RepeatField otherRepeatField : otherRepeatTimes) {
                        if (otherRepeatField == null) continue;
                        RepeatField newRF = (RepeatField)otherRepeatField.clone();
                        newTD.addRepeatField(newRF);
                    }
                }
                newTDs.add(newTD);
            }
            this.setTimeDescriptions(newTDs);
        }
        if ((otherEmails = otherSessionDescription.getEmails(false)) != null) {
            Vector<EmailField> newEmails = new Vector<EmailField>();
            for (EmailField otherEmailField : otherEmails) {
                if (otherEmailField == null) continue;
                EmailField newEF = (EmailField)otherEmailField.clone();
                newEmails.add(newEF);
            }
            this.setEmails(newEmails);
        }
        if ((otherPhones = otherSessionDescription.getPhones(false)) != null) {
            Vector<PhoneField> newPhones = new Vector<PhoneField>();
            for (PhoneField otherPhoneField : otherPhones) {
                if (otherPhoneField == null) continue;
                PhoneField newPF = (PhoneField)otherPhoneField.clone();
                newPhones.add(newPF);
            }
            this.setPhones(newPhones);
        }
        if ((otherZAs = otherSessionDescription.getZoneAdjustments(false)) != null) {
            Vector<ZoneField> newZAs = new Vector<ZoneField>();
            for (ZoneField otherZoneField : otherZAs) {
                if (otherZoneField == null) continue;
                ZoneField newPF = (ZoneField)otherZoneField.clone();
                newZAs.add(newPF);
            }
            this.setZoneAdjustments(newZAs);
        }
        if ((otherBandwidths = otherSessionDescription.getBandwidths(false)) != null) {
            Vector<BandwidthField> newBandwidths = new Vector<BandwidthField>();
            for (BandwidthField otherBandwidthField : otherBandwidths) {
                if (otherBandwidthField == null) continue;
                BandwidthField newBF = (BandwidthField)otherBandwidthField.clone();
                newBandwidths.add(newBF);
            }
            this.setBandwidths(newBandwidths);
        }
        if ((otherAttributes = otherSessionDescription.getAttributes(false)) != null) {
            Vector<AttributeField> newAttributes = new Vector<AttributeField>();
            for (AttributeField otherAttributeField : otherAttributes) {
                if (otherAttributeField == null) continue;
                AttributeField newBF = (AttributeField)otherAttributeField.clone();
                newAttributes.add(newBF);
            }
            this.setAttributes(newAttributes);
        }
        if ((otherMediaDescriptions = otherSessionDescription.getMediaDescriptions(false)) != null) {
            Vector<MediaDescriptionImpl> newMDs = new Vector<MediaDescriptionImpl>();
            for (MediaDescriptionImpl otherMediaDescription : otherMediaDescriptions) {
                Vector otherAFs;
                KeyField otherKeyField;
                Vector otherBFs;
                ConnectionField otherConnectionField;
                InformationField otherInfoField;
                if (otherMediaDescription == null) continue;
                MediaDescriptionImpl newMD = new MediaDescriptionImpl();
                MediaField otherMediaField = otherMediaDescription.getMediaField();
                if (otherMediaField != null) {
                    MediaField newMF = new MediaField();
                    newMF.setMedia(otherMediaField.getMedia());
                    newMF.setPort(otherMediaField.getPort());
                    newMF.setNports(otherMediaField.getNports());
                    newMF.setProto(otherMediaField.getProto());
                    Vector otherFormats = otherMediaField.getFormats();
                    if (otherFormats != null) {
                        Vector<String> newFormats = new Vector<String>();
                        for (Object otherFormat : otherFormats) {
                            if (otherFormat == null) continue;
                            newFormats.add(String.valueOf(otherFormat));
                        }
                        newMF.setFormats(newFormats);
                    }
                    newMD.setMedia(newMF);
                }
                if ((otherInfoField = otherMediaDescription.getInformationField()) != null) {
                    newMD.setInformationField((InformationField)otherInfoField.clone());
                }
                if ((otherConnectionField = otherMediaDescription.getConnectionField()) != null) {
                    newMD.setConnectionField((ConnectionField)otherConnectionField.clone());
                }
                if ((otherBFs = otherMediaDescription.getBandwidths(false)) != null) {
                    Vector<BandwidthField> newBFs = new Vector<BandwidthField>();
                    for (BandwidthField otherBF : otherBFs) {
                        if (otherBF == null) continue;
                        newBFs.add((BandwidthField)otherBF.clone());
                    }
                    newMD.setBandwidths(newBFs);
                }
                if ((otherKeyField = otherMediaDescription.getKeyField()) != null) {
                    newMD.setKeyField((KeyField)otherKeyField.clone());
                }
                if ((otherAFs = otherMediaDescription.getAttributeFields()) != null) {
                    Vector<AttributeField> newAFs = new Vector<AttributeField>();
                    for (AttributeField otherAF : otherAFs) {
                        if (otherAF == null) continue;
                        newAFs.add((AttributeField)otherAF.clone());
                    }
                    newMD.setAttributeFields(newAFs);
                }
                newMDs.add(newMD);
            }
            this.setMediaDescriptions(newMDs);
        }
    }

    public void addField(SDPField sdpField) throws ParseException {
        try {
            if (sdpField instanceof ProtoVersionField) {
                this.versionImpl = (ProtoVersionField)sdpField;
            } else if (sdpField instanceof OriginField) {
                this.originImpl = (OriginField)sdpField;
            } else if (sdpField instanceof SessionNameField) {
                this.sessionNameImpl = (SessionNameField)sdpField;
            } else if (sdpField instanceof InformationField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setInformationField((InformationField)sdpField);
                } else {
                    this.infoImpl = (InformationField)sdpField;
                }
            } else if (sdpField instanceof URIField) {
                this.uriImpl = (URIField)sdpField;
            } else if (sdpField instanceof ConnectionField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setConnectionField((ConnectionField)sdpField);
                } else {
                    this.connectionImpl = (ConnectionField)sdpField;
                }
            } else if (sdpField instanceof KeyField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.setKey((KeyField)sdpField);
                } else {
                    this.keyImpl = (KeyField)sdpField;
                }
            } else if (sdpField instanceof EmailField) {
                this.getEmails(true).add(sdpField);
            } else if (sdpField instanceof PhoneField) {
                this.getPhones(true).add(sdpField);
            } else if (sdpField instanceof TimeField) {
                this.currentTimeDescription = new TimeDescriptionImpl((TimeField)sdpField);
                this.getTimeDescriptions(true).add(this.currentTimeDescription);
            } else if (sdpField instanceof RepeatField) {
                if (this.currentTimeDescription == null) {
                    throw new ParseException("no time specified", 0);
                }
                this.currentTimeDescription.addRepeatField((RepeatField)sdpField);
            } else if (sdpField instanceof ZoneField) {
                this.getZoneAdjustments(true).add(sdpField);
            } else if (sdpField instanceof BandwidthField) {
                if (this.currentMediaDescription != null) {
                    this.currentMediaDescription.addBandwidthField((BandwidthField)sdpField);
                } else {
                    this.getBandwidths(true).add(sdpField);
                }
            } else if (sdpField instanceof AttributeField) {
                if (this.currentMediaDescription != null) {
                    AttributeField af = (AttributeField)sdpField;
                    String s2 = af.getName();
                    this.currentMediaDescription.addAttribute((AttributeField)sdpField);
                } else {
                    this.getAttributes(true).add(sdpField);
                }
            } else if (sdpField instanceof MediaField) {
                this.currentMediaDescription = new MediaDescriptionImpl();
                this.getMediaDescriptions(true).add(this.currentMediaDescription);
                this.currentMediaDescription.setMediaField((MediaField)sdpField);
            }
        }
        catch (SdpException ex) {
            throw new ParseException(sdpField.encode(), 0);
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        try {
            return new SessionDescriptionImpl(this);
        }
        catch (SdpException e) {
            throw new CloneNotSupportedException();
        }
    }

    @Override
    public Version getVersion() {
        return this.versionImpl;
    }

    @Override
    public void setVersion(Version v) throws SdpException {
        if (v == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(v instanceof ProtoVersionField)) {
            throw new SdpException("The parameter must be an instance of VersionField");
        }
        this.versionImpl = (ProtoVersionField)v;
    }

    @Override
    public Origin getOrigin() {
        return this.originImpl;
    }

    @Override
    public void setOrigin(Origin origin) throws SdpException {
        OriginField o;
        if (origin == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(origin instanceof OriginField)) {
            throw new SdpException("The parameter must be an instance of OriginField");
        }
        this.originImpl = o = (OriginField)origin;
    }

    @Override
    public SessionName getSessionName() {
        return this.sessionNameImpl;
    }

    @Override
    public void setSessionName(SessionName sessionName) throws SdpException {
        SessionNameField s2;
        if (sessionName == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(sessionName instanceof SessionNameField)) {
            throw new SdpException("The parameter must be an instance of SessionNameField");
        }
        this.sessionNameImpl = s2 = (SessionNameField)sessionName;
    }

    @Override
    public Info getInfo() {
        return this.infoImpl;
    }

    @Override
    public void setInfo(Info i) throws SdpException {
        InformationField info;
        if (i == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(i instanceof InformationField)) {
            throw new SdpException("The parameter must be an instance of InformationField");
        }
        this.infoImpl = info = (InformationField)i;
    }

    @Override
    public URI getURI() {
        return this.uriImpl;
    }

    @Override
    public void setURI(URI uri) throws SdpException {
        URIField u;
        if (uri == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(uri instanceof URIField)) {
            throw new SdpException("The parameter must be an instance of URIField");
        }
        this.uriImpl = u = (URIField)uri;
    }

    @Override
    public Vector getEmails(boolean create) throws SdpParseException {
        if (this.emailList == null && create) {
            this.emailList = new Vector();
        }
        return this.emailList;
    }

    @Override
    public void setEmails(Vector emails) throws SdpException {
        if (emails == null) {
            throw new SdpException("The parameter is null");
        }
        this.emailList = emails;
    }

    @Override
    public Vector getPhones(boolean create) throws SdpException {
        if (this.phoneList == null && create) {
            this.phoneList = new Vector();
        }
        return this.phoneList;
    }

    @Override
    public void setPhones(Vector phones) throws SdpException {
        if (phones == null) {
            throw new SdpException("The parameter is null");
        }
        this.phoneList = phones;
    }

    @Override
    public Vector getTimeDescriptions(boolean create) throws SdpException {
        if (this.timeDescriptions == null && create) {
            this.timeDescriptions = new Vector();
        }
        return this.timeDescriptions;
    }

    @Override
    public void setTimeDescriptions(Vector times) throws SdpException {
        if (times == null) {
            throw new SdpException("The parameter is null");
        }
        this.timeDescriptions = times;
    }

    @Override
    public Vector getZoneAdjustments(boolean create) throws SdpException {
        if (this.zoneAdjustments == null && create) {
            this.zoneAdjustments = new Vector();
        }
        return this.zoneAdjustments;
    }

    @Override
    public void setZoneAdjustments(Vector zoneAdjustments) throws SdpException {
        if (zoneAdjustments == null) {
            throw new SdpException("The parameter is null");
        }
        this.zoneAdjustments = zoneAdjustments;
    }

    @Override
    public Connection getConnection() {
        return this.connectionImpl;
    }

    @Override
    public void setConnection(Connection conn) throws SdpException {
        ConnectionField c;
        if (conn == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(conn instanceof ConnectionField)) {
            throw new SdpException("Bad implementation class ConnectionField");
        }
        this.connectionImpl = c = (ConnectionField)conn;
    }

    @Override
    public Vector getBandwidths(boolean create) {
        if (this.bandwidthList == null && create) {
            this.bandwidthList = new Vector();
        }
        return this.bandwidthList;
    }

    @Override
    public void setBandwidths(Vector bandwidthList) throws SdpException {
        if (bandwidthList == null) {
            throw new SdpException("The parameter is null");
        }
        this.bandwidthList = bandwidthList;
    }

    @Override
    public int getBandwidth(String name) throws SdpParseException {
        if (name == null) {
            return -1;
        }
        if (this.bandwidthList == null) {
            return -1;
        }
        for (int i = 0; i < this.bandwidthList.size(); ++i) {
            BandwidthField b;
            String type;
            Object o = this.bandwidthList.elementAt(i);
            if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
            return b.getValue();
        }
        return -1;
    }

    @Override
    public void setBandwidth(String name, int value2) throws SdpException {
        if (name == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                BandwidthField b;
                String type;
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField) || (type = (b = (BandwidthField)o).getType()) == null || !name.equals(type)) continue;
                b.setValue(value2);
            }
        }
    }

    @Override
    public void removeBandwidth(String name) {
        if (name != null && this.bandwidthList != null) {
            for (int i = 0; i < this.bandwidthList.size(); ++i) {
                Object o = this.bandwidthList.elementAt(i);
                if (!(o instanceof BandwidthField)) continue;
                BandwidthField b = (BandwidthField)o;
                try {
                    String type = b.getType();
                    if (type == null || !name.equals(type)) continue;
                    this.bandwidthList.remove(b);
                    continue;
                }
                catch (SdpParseException sdpParseException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public Key getKey() {
        return this.keyImpl;
    }

    @Override
    public void setKey(Key key) throws SdpException {
        KeyField k;
        if (key == null) {
            throw new SdpException("The parameter is null");
        }
        if (!(key instanceof KeyField)) {
            throw new SdpException("The parameter must be an instance of KeyField");
        }
        this.keyImpl = k = (KeyField)key;
    }

    @Override
    public String getAttribute(String name) throws SdpParseException {
        if (name == null) {
            return null;
        }
        if (this.attributesList == null) {
            return null;
        }
        for (int i = 0; i < this.attributesList.size(); ++i) {
            AttributeField a;
            String n;
            Object o = this.attributesList.elementAt(i);
            if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
            return a.getValue();
        }
        return null;
    }

    @Override
    public Vector getAttributes(boolean create) {
        if (this.attributesList == null && create) {
            this.attributesList = new Vector();
        }
        return this.attributesList;
    }

    @Override
    public void removeAttribute(String name) {
        if (name != null && this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField)) continue;
                AttributeField a = (AttributeField)o;
                try {
                    String n = a.getName();
                    if (n == null || !name.equals(n)) continue;
                    this.attributesList.remove(a);
                    continue;
                }
                catch (SdpParseException sdpParseException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void setAttribute(String name, String value2) throws SdpException {
        if (name == null || value2 == null) {
            throw new SdpException("The parameter is null");
        }
        if (this.attributesList != null) {
            for (int i = 0; i < this.attributesList.size(); ++i) {
                AttributeField a;
                String n;
                Object o = this.attributesList.elementAt(i);
                if (!(o instanceof AttributeField) || (n = (a = (AttributeField)o).getName()) == null || !name.equals(n)) continue;
                a.setValue(value2);
            }
        }
    }

    @Override
    public void setAttributes(Vector attributes) throws SdpException {
        if (attributes == null) {
            throw new SdpException("The parameter is null");
        }
        this.attributesList = attributes;
    }

    @Override
    public Vector getMediaDescriptions(boolean create) throws SdpException {
        if (this.mediaDescriptions == null && create) {
            this.mediaDescriptions = new Vector();
        }
        return this.mediaDescriptions;
    }

    @Override
    public void setMediaDescriptions(Vector mediaDescriptions) throws SdpException {
        if (mediaDescriptions == null) {
            throw new SdpException("The parameter is null");
        }
        this.mediaDescriptions = mediaDescriptions;
    }

    private String encodeVector(Vector vector) {
        StringBuilder encBuff = new StringBuilder();
        for (int i = 0; i < vector.size(); ++i) {
            encBuff.append(vector.elementAt(i));
        }
        return encBuff.toString();
    }

    public String toString() {
        StringBuilder encBuff = new StringBuilder();
        encBuff.append(this.getVersion() == null ? "" : this.getVersion().toString());
        encBuff.append(this.getOrigin() == null ? "" : this.getOrigin().toString());
        encBuff.append(this.getSessionName() == null ? "" : this.getSessionName().toString());
        encBuff.append(this.getInfo() == null ? "" : this.getInfo().toString());
        try {
            encBuff.append(this.getURI() == null ? "" : this.getURI().toString());
            encBuff.append(this.getEmails(false) == null ? "" : this.encodeVector(this.getEmails(false)));
            encBuff.append(this.getPhones(false) == null ? "" : this.encodeVector(this.getPhones(false)));
            encBuff.append(this.getConnection() == null ? "" : this.getConnection().toString());
            encBuff.append(this.getBandwidths(false) == null ? "" : this.encodeVector(this.getBandwidths(false)));
            encBuff.append(this.getTimeDescriptions(false) == null ? "" : this.encodeVector(this.getTimeDescriptions(false)));
            encBuff.append(this.getZoneAdjustments(false) == null ? "" : this.encodeVector(this.getZoneAdjustments(false)));
            encBuff.append(this.getKey() == null ? "" : this.getKey().toString());
            encBuff.append(this.getAttributes(false) == null ? "" : this.encodeVector(this.getAttributes(false)));
            encBuff.append(this.getMediaDescriptions(false) == null ? "" : this.encodeVector(this.getMediaDescriptions(false)));
        }
        catch (SdpException sdpException) {
            // empty catch block
        }
        return encBuff.toString();
    }
}

