/*
 * Decompiled with CFR 0.152.
 */
package org.xeustechnologies.jcl;

import java.io.InputStream;
import java.net.URL;
import org.xeustechnologies.jcl.AbstractClassLoader;
import org.xeustechnologies.jcl.ProxyClassLoader;

public class DelegateProxyClassLoader
extends ProxyClassLoader {
    private final AbstractClassLoader delegate;

    public DelegateProxyClassLoader(AbstractClassLoader delegate) throws NullPointerException {
        if (delegate == null) {
            throw new NullPointerException("delegate can't be null");
        }
        this.delegate = delegate;
        this.order = 15;
    }

    @Override
    public Class loadClass(String className, boolean resolveIt) {
        Class result;
        try {
            result = this.delegate.loadClass(className, resolveIt);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return result;
    }

    @Override
    public InputStream loadResource(String name) {
        return this.delegate.getResourceAsStream(name);
    }

    @Override
    public URL findResource(String name) {
        return this.delegate.getResource(name);
    }

    public AbstractClassLoader getDelegate() {
        return this.delegate;
    }
}

