/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.jigasi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.conference.JitsiMeetConferenceImpl;
import org.jitsi.jicofo.jigasi.JigasiDetector;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppProvider;
import org.jitsi.jicofo.xmpp.muc.ChatRoom;
import org.jitsi.jicofo.xmpp.muc.ChatRoomListener;
import org.jitsi.jicofo.xmpp.muc.ChatRoomMember;
import org.jitsi.jicofo.xmpp.muc.DefaultChatRoomListener;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.xmpp.extensions.jitsimeet.TranscriptionRequestExtension;
import org.jitsi.xmpp.extensions.jitsimeet.TranscriptionStatusExtension;
import org.jitsi.xmpp.extensions.rayo.DialIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Presence;
import org.jxmpp.jid.Jid;

public class TranscriberManager {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ChatRoom chatRoom;
    @NotNull
    private final JitsiMeetConferenceImpl conference;
    @NotNull
    private final ChatRoomListener chatRoomListener = new ChatRoomListenerImpl();
    private final JigasiDetector jigasiDetector;
    @NotNull
    private final AbstractXMPPConnection connection;
    private volatile boolean active;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public TranscriberManager(@NotNull XmppProvider xmppProvider, @NotNull JitsiMeetConferenceImpl conference, @NotNull ChatRoom chatRoom, JigasiDetector jigasiDetector2, @NotNull Logger parentLogger) {
        this.logger = parentLogger.createChildLogger(this.getClass().getName());
        this.connection = xmppProvider.getXmppConnection();
        this.conference = conference;
        this.chatRoom = chatRoom;
        chatRoom.addListener(this.chatRoomListener);
        this.jigasiDetector = jigasiDetector2;
    }

    public void dispose() {
        this.executorService.shutdown();
        this.chatRoom.removeListener(this.chatRoomListener);
        this.logger.debug("disposed transcriber manager");
    }

    private void memberPresenceChanged(@NotNull ChatRoomMember member) {
        Presence presence = member.getPresence();
        if (presence == null) {
            return;
        }
        TranscriptionStatusExtension transcriptionStatusExtension = this.getTranscriptionStatus(presence);
        if (transcriptionStatusExtension != null && TranscriptionStatusExtension.Status.OFF.equals((Object)transcriptionStatusExtension.getStatus())) {
            this.active = false;
            this.logger.info("detected transcription status being turned off.");
        }
        if (this.isRequestingTranscriber(presence) && !this.active) {
            this.tryToStart();
        }
    }

    private void tryToStart() {
        if (this.jigasiDetector == null) {
            this.logger.warn("Transcription requested, but jigasiDetector is not configured.");
            return;
        }
        if (this.active) {
            return;
        }
        this.executorService.execute(() -> {
            if (this.active) {
                return;
            }
            this.selectTranscriber(2, new ArrayList<Jid>(), this.conference.getBridgeRegions());
        });
    }

    private TranscriptionStatusExtension getTranscriptionStatus(Presence p) {
        return p.getExtension(TranscriptionStatusExtension.class);
    }

    private void startTranscribing(@NotNull Collection<String> preferredRegions) {
    }

    private void selectTranscriber(int retryCount, @NotNull List<Jid> exclude, @NotNull Collection<String> preferredRegions) {
        this.logger.info("Attempting to invite transcriber");
        Jid jigasiJid = this.jigasiDetector.selectTranscriber(exclude, preferredRegions);
        if (jigasiJid == null) {
            this.logger.warn("Unable to invite transcriber due to no Jigasi instances being available");
            return;
        }
        DialIq dialIq = new DialIq();
        dialIq.setDestination("jitsi_meet_transcribe");
        dialIq.setTo(jigasiJid);
        dialIq.setType(IQ.Type.set);
        dialIq.setHeader("JvbRoomName", this.chatRoom.getRoomJid().toString());
        try {
            IQ response = UtilKt.sendIqAndGetResponse(this.connection, dialIq);
            boolean retry = false;
            if (response != null) {
                if (response.getError() == null) {
                    this.active = true;
                    this.logger.info("transcriber was successfully invited");
                } else {
                    this.logger.warn("failed to invite transcriber. Got error: " + response.getError().getErrorGenerator());
                    retry = true;
                }
            } else {
                this.logger.warn("failed to invite transcriber; lack of response from XmmpConnection");
                retry = true;
            }
            if (retry && retryCount > 0) {
                exclude.add(jigasiJid);
                this.selectTranscriber(retryCount - 1, exclude, preferredRegions);
            }
        }
        catch (SmackException.NotConnectedException e) {
            this.logger.error("Failed sending dialIq to transcriber", e);
        }
    }

    private boolean isRequestingTranscriber(Presence presence) {
        if (presence == null) {
            return false;
        }
        TranscriptionRequestExtension ext = presence.getExtension(TranscriptionRequestExtension.class);
        if (ext == null) {
            return false;
        }
        return Boolean.parseBoolean(ext.getText());
    }

    private class ChatRoomListenerImpl
    extends DefaultChatRoomListener {
        private ChatRoomListenerImpl() {
        }

        @Override
        public void memberPresenceChanged(@NotNull ChatRoomMember member) {
            TranscriberManager.this.memberPresenceChanged(member);
        }

        @Override
        public void transcriptionRequestedChanged(boolean transcriptionRequested2) {
            if (transcriptionRequested2) {
                TranscriberManager.this.logger.info("Transcription requested from the room.");
                TranscriberManager.this.tryToStart();
            }
        }
    }
}

