/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.jicofo.bridge.Bridge;
import org.jitsi.jicofo.bridge.BridgeConfig;
import org.jitsi.jicofo.bridge.ConferenceBridgeProperties;
import org.jitsi.jicofo.bridge.ParticipantProperties;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.json.simple.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\t\b&\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0017\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH&J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00070\b2\b\u0010!\u001a\u0004\u0018\u00010\u0007H\u0004J$\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001cH\u0002J2\u0010%\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ<\u0010&\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u0010(\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u0010)\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u0010*\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J8\u0010+\u001a\u00020,2\u0006\u0010$\u001a\u00020\u00182\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010\u0007H\u0002J2\u0010-\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ<\u0010.\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u0010/\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u00100\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u00101\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010'\u001a\u0004\u0018\u00010\u0007J<\u00102\u001a\u0004\u0018\u00010\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00180\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00103\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy;", "", "()V", "maxParticipantsPerBridge", "", "regionGroups", "", "", "", "stats", "Lorg/json/simple/JSONObject;", "getStats", "()Lorg/json/simple/JSONObject;", "totalLeastLoaded", "totalLeastLoadedAlreadyInConference", "totalLeastLoadedAlreadyInConferenceInRegion", "totalLeastLoadedAlreadyInConferenceInRegionGroup", "totalLeastLoadedInRegion", "totalLeastLoadedInRegionGroup", "totalNotLoadedAlreadyInConferenceInRegion", "totalNotLoadedAlreadyInConferenceInRegionGroup", "totalNotLoadedInRegion", "totalNotLoadedInRegionGroup", "doSelect", "Lorg/jitsi/jicofo/bridge/Bridge;", "bridges", "", "conferenceBridges", "", "Lorg/jitsi/jicofo/bridge/ConferenceBridgeProperties;", "participantProperties", "Lorg/jitsi/jicofo/bridge/ParticipantProperties;", "getRegionGroup", "region", "isOverloaded", "", "bridge", "leastLoaded", "leastLoadedAlreadyInConferenceInRegion", "desiredRegion", "leastLoadedAlreadyInConferenceInRegionGroup", "leastLoadedInRegion", "leastLoadedInRegionGroup", "logSelection", "", "nonLoadedAlreadyInConference", "notLoadedAlreadyInConferenceInRegion", "notLoadedAlreadyInConferenceInRegionGroup", "notLoadedInRegion", "notLoadedInRegionGroup", "select", "allowMultiBridge", "Companion", "jicofo-selector"})
@SourceDebugExtension(value={"SMAP\nBridgeSelectionStrategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeSelectionStrategy.kt\norg/jitsi/jicofo/bridge/BridgeSelectionStrategy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,451:1\n1855#2:452\n1855#2,2:453\n1856#2:455\n819#2:456\n847#2,2:457\n288#2,2:459\n819#2:461\n847#2,2:462\n288#2,2:464\n819#2:466\n847#2,2:467\n288#2,2:469\n819#2:471\n847#2,2:472\n288#2,2:474\n288#2,2:476\n288#2,2:478\n288#2,2:480\n288#2,2:482\n819#2:484\n847#2,2:485\n*S KotlinDebug\n*F\n+ 1 BridgeSelectionStrategy.kt\norg/jitsi/jicofo/bridge/BridgeSelectionStrategy\n*L\n413#1:452\n414#1:453,2\n413#1:455\n163#1:456\n163#1:457,2\n165#1:459,2\n181#1:461\n181#1:462,2\n183#1:464,2\n222#1:466\n222#1:467,2\n223#1:469,2\n239#1:471\n239#1:472,2\n240#1:474,2\n268#1:476,2\n285#1:478,2\n309#1:480,2\n325#1:482,2\n348#1:484\n348#1:485,2\n*E\n"})
public abstract class BridgeSelectionStrategy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int totalNotLoadedAlreadyInConferenceInRegion;
    private int totalNotLoadedAlreadyInConferenceInRegionGroup;
    private int totalNotLoadedInRegion;
    private int totalNotLoadedInRegionGroup;
    private int totalLeastLoadedAlreadyInConferenceInRegion;
    private int totalLeastLoadedAlreadyInConferenceInRegionGroup;
    private int totalLeastLoadedInRegion;
    private int totalLeastLoadedInRegionGroup;
    private int totalLeastLoadedAlreadyInConference;
    private int totalLeastLoaded;
    private final int maxParticipantsPerBridge = BridgeConfig.config.maxBridgeParticipants();
    @NotNull
    private final Map<String, Set<String>> regionGroups = new HashMap();
    @NotNull
    private static final Logger logger = new LoggerImpl(BridgeSelectionStrategy.class.getName());

    public BridgeSelectionStrategy() {
        Iterable $this$forEach$iv = BridgeConfig.config.getRegionGroups();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Set regionGroup = (Set)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = regionGroup;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String region = (String)element$iv2;
                boolean bl2 = false;
                this.regionGroups.put(region, regionGroup);
            }
        }
    }

    @Nullable
    public Bridge select(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, boolean allowMultiBridge) {
        Bridge bridge2;
        Intrinsics.checkNotNullParameter(bridges, "bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
        if (conferenceBridges.isEmpty()) {
            Bridge bridge3 = this.doSelect(bridges, conferenceBridges, participantProperties);
            if (bridge3 != null) {
                logger.info("Selected initial bridge " + bridge3 + " with reported stress=" + bridge3.getLastReportedStressLevel() + " for participantProperties=" + participantProperties + " using strategy " + this.getClass().getSimpleName());
            } else {
                logger.warn("Failed to select initial bridge for participantProperties=" + participantProperties);
            }
            bridge2 = bridge3;
        } else {
            Bridge existingBridge = (Bridge)CollectionsKt.first((Iterable)conferenceBridges.keySet());
            if (!allowMultiBridge || existingBridge.getRelayId() == null) {
                logger.info("Existing bridge does not have a relay, will not consider other bridges.");
                return existingBridge;
            }
            Bridge bridge4 = this.doSelect(bridges, conferenceBridges, participantProperties);
            if (bridge4 != null) {
                logger.info("Selected bridge " + bridge4 + " with stress=" + bridge4.getLastReportedStressLevel() + " for participantProperties=" + participantProperties);
            } else {
                logger.warn("Failed to select bridge for participantProperties=" + participantProperties);
            }
            bridge2 = bridge4;
        }
        return bridge2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedAlreadyInConferenceInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = CollectionsKt.intersect((List)destination$iv$iv, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default(it.getRegion(), desiredRegion, false, 2, null))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalNotLoadedAlreadyInConferenceInRegion;
            this.totalNotLoadedAlreadyInConferenceInRegion = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedAlreadyInConferenceInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Set<String> regionGroup = this.getRegionGroup(desiredRegion);
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = CollectionsKt.intersect((List)destination$iv$iv, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, it.getRegion())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalNotLoadedAlreadyInConferenceInRegionGroup;
            this.totalNotLoadedAlreadyInConferenceInRegionGroup = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    private final void logSelection(Bridge bridge2, Map<Bridge, ConferenceBridgeProperties> conferenceBridges, ParticipantProperties participantProperties, String desiredRegion) {
        String method = Thread.currentThread().getStackTrace()[2].getMethodName();
        logger.debug(() -> BridgeSelectionStrategy.logSelection$lambda$4(method, desiredRegion, participantProperties, bridge2, conferenceBridges));
    }

    static /* synthetic */ void logSelection$default(BridgeSelectionStrategy bridgeSelectionStrategy, Bridge bridge2, Map map, ParticipantProperties participantProperties, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: logSelection");
        }
        if ((n & 8) != 0) {
            string = null;
        }
        bridgeSelectionStrategy.logSelection(bridge2, map, participantProperties, string);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default(it.getRegion(), desiredRegion, false, 2, null))) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalNotLoadedInRegion;
            this.totalNotLoadedInRegion = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge notLoadedInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block3: {
            void $this$firstOrNull$iv;
            void $this$filterNotTo$iv$iv;
            Iterable $this$filterNot$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Set<String> regionGroup = this.getRegionGroup(desiredRegion);
            Iterable iterable = bridges;
            boolean $i$f$filterNot = false;
            Iterator iterator2 = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl = false;
                if (this.isOverloaded(it, conferenceBridges)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, it.getRegion())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalNotLoadedInRegionGroup;
            this.totalNotLoadedInRegionGroup = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedAlreadyInConferenceInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Iterable iterable = CollectionsKt.intersect((Iterable)bridges, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default(it.getRegion(), desiredRegion, false, 2, null))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalLeastLoadedAlreadyInConferenceInRegion;
            this.totalLeastLoadedAlreadyInConferenceInRegion = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedAlreadyInConferenceInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Set<String> regionGroup = this.getRegionGroup(desiredRegion);
            Iterable iterable = CollectionsKt.intersect((Iterable)bridges, (Iterable)conferenceBridges.keySet());
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, it.getRegion())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalLeastLoadedAlreadyInConferenceInRegionGroup;
            this.totalLeastLoadedAlreadyInConferenceInRegionGroup = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedInRegion(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Iterable iterable = bridges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!(desiredRegion != null && StringsKt.equals$default(it.getRegion(), desiredRegion, false, 2, null))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalLeastLoadedInRegion;
            this.totalLeastLoadedInRegion = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge leastLoadedInRegionGroup(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties, @Nullable String desiredRegion) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter(bridges, "bridges");
            Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
            Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
            Set<String> regionGroup = this.getRegionGroup(desiredRegion);
            Iterable iterable = bridges;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Bridge it = (Bridge)element$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)regionGroup, it.getRegion())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Bridge result = v0;
        if (result != null) {
            int n = this.totalLeastLoadedInRegionGroup;
            this.totalLeastLoadedInRegionGroup = n + 1;
            this.logSelection(result, conferenceBridges, participantProperties, desiredRegion);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Bridge nonLoadedAlreadyInConference(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(bridges, "bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
        Iterable iterable = bridges;
        boolean $i$f$filterNot = false;
        void var7_7 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Bridge it = (Bridge)element$iv$iv;
            boolean bl = false;
            if (this.isOverloaded(it, conferenceBridges)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Bridge result = (Bridge)CollectionsKt.firstOrNull(CollectionsKt.intersect((List)destination$iv$iv, (Iterable)conferenceBridges.keySet()));
        if (result != null) {
            int n = this.totalLeastLoadedAlreadyInConference;
            this.totalLeastLoadedAlreadyInConference = n + 1;
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    @Nullable
    public final Bridge leastLoaded(@NotNull List<Bridge> bridges, @NotNull Map<Bridge, ConferenceBridgeProperties> conferenceBridges, @NotNull ParticipantProperties participantProperties) {
        Intrinsics.checkNotNullParameter(bridges, "bridges");
        Intrinsics.checkNotNullParameter(conferenceBridges, "conferenceBridges");
        Intrinsics.checkNotNullParameter(participantProperties, "participantProperties");
        Bridge result = CollectionsKt.firstOrNull(bridges);
        if (result != null) {
            int n = this.totalLeastLoaded;
            this.totalLeastLoaded = n + 1;
            BridgeSelectionStrategy.logSelection$default(this, result, conferenceBridges, participantProperties, null, 8, null);
        }
        return result;
    }

    @Nullable
    public abstract Bridge doSelect(@NotNull List<Bridge> var1, @NotNull Map<Bridge, ConferenceBridgeProperties> var2, @NotNull ParticipantProperties var3);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isOverloaded(Bridge bridge2, Map<Bridge, ConferenceBridgeProperties> conferenceBridges) {
        if (bridge2.isOverloaded()) return true;
        if (this.maxParticipantsPerBridge <= 0) return false;
        if (!conferenceBridges.containsKey(bridge2)) return false;
        ConferenceBridgeProperties conferenceBridgeProperties = conferenceBridges.get(bridge2);
        Intrinsics.checkNotNull(conferenceBridgeProperties);
        if (conferenceBridgeProperties.getParticipantCount() < this.maxParticipantsPerBridge) return false;
        return true;
    }

    @NotNull
    protected final Set<String> getRegionGroup(@Nullable String region) {
        if (region == null) {
            return SetsKt.emptySet();
        }
        Set<String> regionGroup = this.regionGroups.get(region);
        Set<String> set = regionGroup;
        if (set == null) {
            set = SetsKt.setOf(region);
        }
        return set;
    }

    @NotNull
    public final JSONObject getStats() {
        JSONObject json = new JSONObject();
        ((Map)json).put("total_not_loaded_in_region_in_conference", this.totalNotLoadedAlreadyInConferenceInRegion);
        ((Map)json).put("total_not_loaded_in_region_group_in_conference", this.totalNotLoadedAlreadyInConferenceInRegionGroup);
        ((Map)json).put("total_not_loaded_in_region", this.totalNotLoadedInRegion);
        ((Map)json).put("total_not_loaded_in_region_group", this.totalNotLoadedInRegionGroup);
        ((Map)json).put("total_least_loaded_in_region_in_conference", this.totalLeastLoadedAlreadyInConferenceInRegion);
        ((Map)json).put("total_least_loaded_in_region_group_in_conference", this.totalLeastLoadedAlreadyInConferenceInRegionGroup);
        ((Map)json).put("total_least_loaded_in_region", this.totalLeastLoadedInRegion);
        ((Map)json).put("total_least_loaded_in_region_group", this.totalLeastLoadedInRegionGroup);
        ((Map)json).put("total_least_loaded_in_conference", this.totalLeastLoadedAlreadyInConference);
        ((Map)json).put("total_least_loaded", this.totalLeastLoaded);
        return json;
    }

    private static final String logSelection$lambda$4(String $method, String $desiredRegion, ParticipantProperties $participantProperties, Bridge $bridge, Map $conferenceBridges) {
        Intrinsics.checkNotNullParameter($participantProperties, "$participantProperties");
        Intrinsics.checkNotNullParameter($bridge, "$bridge");
        Intrinsics.checkNotNullParameter($conferenceBridges, "$conferenceBridges");
        return "Bridge selected: method=" + $method + ", desiredRegion=" + $desiredRegion + ", participantProperties=" + $participantProperties + ", bridge=" + $bridge + ", conference_bridges=" + CollectionsKt.joinToString$default($conferenceBridges.keySet(), null, null, null, 0, null, null, 63, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jitsi/jicofo/bridge/BridgeSelectionStrategy$Companion;", "", "()V", "logger", "Lorg/jitsi/utils/logging2/Logger;", "jicofo-selector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

