/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;

abstract class TypeVisitor<T> {
    TypeVisitor() {
    }

    public final T visit(Type type2) {
        assert (type2 != null);
        if (type2 instanceof Class) {
            return this.onClass((Class)type2);
        }
        if (type2 instanceof ParameterizedType) {
            return this.onParameterizedType((ParameterizedType)type2);
        }
        if (type2 instanceof GenericArrayType) {
            return this.onGenericArray((GenericArrayType)type2);
        }
        if (type2 instanceof WildcardType) {
            return this.onWildcard((WildcardType)type2);
        }
        if (type2 instanceof TypeVariable) {
            return this.onVariable((TypeVariable)type2);
        }
        assert (false);
        throw this.createError(type2);
    }

    protected abstract T onClass(Class var1);

    protected abstract T onParameterizedType(ParameterizedType var1);

    protected abstract T onGenericArray(GenericArrayType var1);

    protected abstract T onVariable(TypeVariable var1);

    protected abstract T onWildcard(WildcardType var1);

    protected RuntimeException createError(Type type2) {
        throw new IllegalArgumentException();
    }
}

