/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.desktopgui;

import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.accessibility.Accessible;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingWorker;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.i2p.I2PAppContext;
import net.i2p.app.MenuCallback;
import net.i2p.app.MenuHandle;
import net.i2p.desktopgui.i18n.DesktopguiTranslator;
import net.i2p.util.SystemVersion;

abstract class TrayManager {
    protected final I2PAppContext _appContext;
    protected final boolean _useSwing;
    protected SystemTray tray;
    protected TrayIcon trayIcon;
    protected volatile boolean _showNotifications;
    protected MenuItem _notificationItem1;
    protected MenuItem _notificationItem2;
    protected JMenuItem _jnotificationItem1;
    protected JMenuItem _jnotificationItem2;
    private final AtomicInteger _id = new AtomicInteger();
    private final List<MenuInternal> _menus;
    private JPopupMenu _jPopupMenu;
    private static final String PNG_DIR = "/desktopgui/resources/images/";
    private static final String MAC_ICON = "itoopie_black_24.png";
    private static final String WIN_ICON_LIGHT = "itoopie_white_24.png";
    private static final String WIN_ICON_DARK = "itoopie_black_24.png";
    private static final String LIN_ICON = "logo.png";
    protected static final String PROP_NOTIFICATIONS = "desktopgui.showNotifications";

    protected TrayManager(I2PAppContext ctx, boolean useSwing) {
        this._appContext = ctx;
        this._useSwing = useSwing;
        this._menus = new ArrayList<MenuInternal>();
    }

    public synchronized void startManager() throws AWTException {
        if (!SystemTray.isSupported()) {
            throw new AWTException("SystemTray not supported");
        }
        this._showNotifications = this._appContext.getBooleanPropertyDefaultTrue(PROP_NOTIFICATIONS);
        this.tray = SystemTray.getSystemTray();
        String tooltip = SystemVersion.isWindows() ? this._t("I2P: Right-click for menu") : null;
        TrayIcon ti = this._useSwing ? this.getSwingTrayIcon(tooltip) : this.getAWTTrayIcon(tooltip);
        ti.setImageAutoSize(true);
        this.tray.add(ti);
        this.trayIcon = ti;
    }

    private TrayIcon getAWTTrayIcon(String tooltip) throws AWTException {
        PopupMenu menu = this.getMainMenu();
        if (!SystemVersion.isWindows()) {
            menu.setFont(new Font("Arial", 1, 14));
        }
        TrayIcon ti = new TrayIcon(this.getTrayImage(), tooltip, menu);
        ti.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent m) {
            }

            @Override
            public void mouseEntered(MouseEvent m) {
            }

            @Override
            public void mouseExited(MouseEvent m) {
            }

            @Override
            public void mousePressed(MouseEvent m) {
                TrayManager.this.updateMenu();
            }

            @Override
            public void mouseReleased(MouseEvent m) {
                TrayManager.this.updateMenu();
            }
        });
        return ti;
    }

    private TrayIcon getSwingTrayIcon(String tooltip) throws AWTException {
        JPopupMenu menu;
        final JFrame frame = new JFrame();
        frame.setUndecorated(true);
        frame.setMinimumSize(new Dimension(0, 0));
        frame.setSize(0, 0);
        this._jPopupMenu = menu = this.getSwingMainMenu();
        menu.setFocusable(true);
        frame.add(menu);
        TrayIcon ti = new TrayIcon(this.getTrayImage(), tooltip, null);
        ti.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.handle(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.handle(e);
            }

            private void handle(MouseEvent e) {
                if (!frame.isVisible()) {
                    frame.setLocation(e.getX(), e.getY());
                    frame.setVisible(true);
                    menu.show(frame, 0, 0);
                }
                TrayManager.this.updateMenu();
            }
        });
        menu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                frame.setVisible(false);
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        menu.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                frame.setVisible(false);
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
                if (e.getKeyChar() == '\u001b') {
                    frame.setVisible(false);
                }
            }
        });
        return ti;
    }

    public synchronized void stopManager() {
        if (this.tray != null && this.trayIcon != null) {
            this.tray.remove(this.trayIcon);
            this.tray = null;
            this.trayIcon = null;
        }
    }

    public synchronized void languageChanged() {
        if (this.trayIcon != null && !this._useSwing) {
            this.trayIcon.setPopupMenu(this.getMainMenu());
        }
    }

    protected abstract PopupMenu getMainMenu();

    protected abstract JPopupMenu getSwingMainMenu();

    protected abstract void updateMenu();

    private Image getTrayImage() throws AWTException {
        String theme;
        String img = SystemVersion.isWindows() ? ((theme = this._appContext.getProperty("routerconsole.theme", "light")).equals("dark") ? WIN_ICON_LIGHT : "itoopie_black_24.png") : (SystemVersion.isMac() ? "itoopie_black_24.png" : LIN_ICON);
        URL url = this.getClass().getResource(PNG_DIR + img);
        if (url == null) {
            throw new AWTException("cannot load tray image " + img);
        }
        Image image = Toolkit.getDefaultToolkit().getImage(url);
        return image;
    }

    public int displayMessage(int priority, String title, String message, String path) {
        if (!this._showNotifications) {
            return -1;
        }
        TrayIcon ti = this.trayIcon;
        if (ti == null) {
            return -1;
        }
        TrayIcon.MessageType type = priority <= 10 ? TrayIcon.MessageType.NONE : (priority <= 20 ? TrayIcon.MessageType.INFO : (priority <= 30 ? TrayIcon.MessageType.WARNING : TrayIcon.MessageType.ERROR));
        ti.displayMessage(title, message, type);
        return 0;
    }

    protected void configureNotifications(boolean enable) {
        this._showNotifications = enable;
    }

    protected void initializeNotificationItems() {
        MenuItem notificationItem2 = new MenuItem(this._t("Enable notifications"));
        notificationItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        TrayManager.this.configureNotifications(true);
                        return null;
                    }
                }.execute();
            }
        });
        this._notificationItem2 = notificationItem2;
        MenuItem notificationItem1 = new MenuItem(this._t("Disable notifications"));
        notificationItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        TrayManager.this.configureNotifications(false);
                        return null;
                    }
                }.execute();
            }
        });
        this._notificationItem1 = notificationItem1;
    }

    protected void initializeJNotificationItems() {
        JMenuItem notificationItem2 = new JMenuItem(this._t("Enable notifications"));
        notificationItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        TrayManager.this.configureNotifications(true);
                        return null;
                    }
                }.execute();
            }
        });
        this._jnotificationItem2 = notificationItem2;
        JMenuItem notificationItem1 = new JMenuItem(this._t("Disable notifications"));
        notificationItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SwingWorker<Object, Object>(){

                    @Override
                    protected Object doInBackground() throws Exception {
                        TrayManager.this.configureNotifications(false);
                        return null;
                    }
                }.execute();
            }
        });
        this._jnotificationItem1 = notificationItem1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MenuHandle addMenu(String message, MenuCallback callback, MenuHandle p) {
        MenuInternal rv;
        Accessible m;
        MenuInternal parent = p != null ? (MenuInternal)p : null;
        int id = this._id.incrementAndGet();
        if (this._useSwing) {
            m = new JMenuItem(message);
            rv = new MenuInternal(null, (JMenuItem)m, callback, id);
            ((AbstractButton)((Object)m)).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            rv.cb.clicked(rv);
                            return null;
                        }
                    }.execute();
                }
            });
            this._jPopupMenu.add((JMenuItem)m);
        } else {
            m = new MenuItem(message);
            rv = new MenuInternal((MenuItem)m, null, callback, id);
            ((MenuItem)m).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    new SwingWorker<Object, Object>(){

                        @Override
                        protected Object doInBackground() throws Exception {
                            rv.cb.clicked(rv);
                            return null;
                        }
                    }.execute();
                }
            });
            this.trayIcon.getPopupMenu().add((MenuItem)m);
        }
        List<MenuInternal> list = this._menus;
        synchronized (list) {
            this._menus.add(rv);
        }
        this.updateMenu();
        return rv;
    }

    public void removeMenu(MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        if (this._useSwing) {
            this._jPopupMenu.remove(mi.jm);
        } else {
            this.trayIcon.getPopupMenu().remove(mi.m);
        }
        this.updateMenu();
    }

    public void showMenu(MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        mi.setVisible(true);
        this.updateMenu();
    }

    public void hideMenu(MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        mi.setVisible(false);
        this.updateMenu();
    }

    public void enableMenu(MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        mi.setEnabled(true);
        this.updateMenu();
    }

    public void disableMenu(MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        mi.setEnabled(false);
        this.updateMenu();
    }

    public void updateMenu(String message, MenuHandle item) {
        MenuInternal mi = (MenuInternal)item;
        mi.setText(message);
        this.updateMenu();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MenuInternal getMenu(int id) {
        List<MenuInternal> list = this._menus;
        synchronized (list) {
            for (MenuInternal mi : this._menus) {
                if (mi.getID() != id) continue;
                return mi;
            }
        }
        return null;
    }

    protected String _t(String s) {
        return DesktopguiTranslator._t(this._appContext, s);
    }

    protected String _t(String s, Object o) {
        return DesktopguiTranslator._t(this._appContext, s, o);
    }

    private static class MenuInternal
    implements MenuHandle {
        private final MenuItem m;
        private final JMenuItem jm;
        private final MenuCallback cb;
        private final int id;

        public MenuInternal(MenuItem mm, JMenuItem jmm, MenuCallback cbb, int idd) {
            this.m = mm;
            this.jm = jmm;
            this.cb = cbb;
            this.id = idd;
        }

        @Override
        public int getID() {
            return this.id;
        }

        private void setEnabled(boolean yes) {
            if (this.m != null) {
                this.m.setEnabled(yes);
            } else {
                this.jm.setEnabled(yes);
            }
        }

        private void setVisible(boolean yes) {
            if (this.m != null) {
                this.m.setEnabled(yes);
            } else {
                this.jm.setVisible(yes);
            }
        }

        private void setText(String text) {
            if (this.m != null) {
                this.m.setLabel(text);
            } else {
                this.jm.setText(text);
            }
        }
    }
}

