/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.Lease;
import net.i2p.data.Lease2;
import net.i2p.data.LeaseSet;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

public class LeaseSet2
extends LeaseSet {
    protected int _flags;
    protected long _published;
    protected long _expires;
    protected long _transientExpires;
    protected SigningPublicKey _transientSigningPublicKey;
    protected Signature _offlineSignature;
    protected Properties _options;
    private List<PublicKey> _encryptionKeys;
    private Hash _blindedHash;
    private static final boolean IGNORE_SERVER_KEY_PREFERENCE = false;
    private static final int FLAG_OFFLINE_KEYS = 1;
    private static final int FLAG_UNPUBLISHED = 2;
    private static final int FLAG_BLINDED = 4;
    private static final int MAX_KEYS = 8;

    public LeaseSet2() {
        this._checked = true;
    }

    public long getPublished() {
        return this._published;
    }

    public void setPublished(long now) {
        this._published = (now + 500L) / 1000L * 1000L;
    }

    public long getExpires() {
        return this._expires;
    }

    public boolean isUnpublished() {
        return (this._flags & 2) != 0;
    }

    public void setUnpublished() {
        if (this._signature != null && (this._flags & 2) == 0) {
            throw new IllegalStateException();
        }
        this._flags |= 2;
    }

    public boolean isBlindedWhenPublished() {
        return (this._flags & 4) != 0;
    }

    public void setBlindedWhenPublished() {
        if (this._signature != null && (this._flags & 4) == 0) {
            throw new IllegalStateException();
        }
        this._flags |= 4;
    }

    @Override
    public boolean getReceivedAsPublished() {
        return super.getReceivedAsPublished() && !this.isUnpublished();
    }

    public String getOption(String opt) {
        if (this._options == null) {
            return null;
        }
        return this._options.getProperty(opt);
    }

    public Properties getOptions() {
        return this._options;
    }

    @Override
    public PublicKey getEncryptionKey() {
        if (this._encryptionKeys != null) {
            for (PublicKey pk : this._encryptionKeys) {
                EncType type = pk.getType();
                if (type == null || !type.isAvailable()) continue;
                return pk;
            }
        }
        return this._encryptionKey;
    }

    @Override
    public PublicKey getEncryptionKey(Set<EncType> supported) {
        List<PublicKey> keys = this.getEncryptionKeys();
        if (keys == null) {
            return null;
        }
        for (PublicKey pk : keys) {
            if (!supported.contains((Object)pk.getType())) continue;
            return pk;
        }
        return null;
    }

    public void addEncryptionKey(PublicKey key) {
        if (this._encryptionKey == null) {
            this.setEncryptionKey(key);
        } else {
            if (this._encryptionKeys == null) {
                this._encryptionKeys = new ArrayList<PublicKey>(4);
                this._encryptionKeys.add(this._encryptionKey);
            } else if (this._encryptionKeys.size() >= 8) {
                throw new IllegalStateException();
            }
            this._encryptionKeys.add(key);
        }
    }

    public List<PublicKey> getEncryptionKeys() {
        if (this._encryptionKeys != null) {
            return this._encryptionKeys;
        }
        if (this._encryptionKey != null) {
            return Collections.singletonList(this._encryptionKey);
        }
        return null;
    }

    public void setOptions(Properties options) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        if (this._options != null) {
            this._options.clear();
        } else {
            this._options = new OrderedProperties();
        }
        this._options.putAll((Map<?, ?>)options);
    }

    public boolean isOffline() {
        return (this._flags & 1) != 0;
    }

    public SigningPublicKey getTransientSigningKey() {
        return this._transientSigningPublicKey;
    }

    public long getTransientExpiration() {
        return this._transientExpires;
    }

    public boolean setOfflineSignature(long expires, SigningPublicKey transientSPK, Signature offlineSig) {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        this._flags |= 1;
        this._transientExpires = expires;
        this._transientSigningPublicKey = transientSPK;
        this._offlineSignature = offlineSig;
        return this.verifyOfflineSignature();
    }

    public static Signature offlineSign(long expires, SigningPublicKey transientSPK, SigningPrivateKey priv) {
        ByteArrayStream baos = new ByteArrayStream(6 + transientSPK.length());
        try {
            DataHelper.writeLong(baos, 4, expires / 1000L);
            DataHelper.writeLong(baos, 2, transientSPK.getType().getCode());
            transientSPK.writeBytes(baos);
        }
        catch (IOException ioe) {
            return null;
        }
        catch (DataFormatException dfe) {
            return null;
        }
        return baos.sign(priv);
    }

    public boolean verifyOfflineSignature() {
        return this.verifyOfflineSignature(this._destination.getSigningPublicKey());
    }

    protected boolean verifyOfflineSignature(SigningPublicKey spk) {
        if (!this.isOffline()) {
            return false;
        }
        I2PAppContext ctx = I2PAppContext.getGlobalContext();
        if (this._transientExpires < ctx.clock().now()) {
            return false;
        }
        ByteArrayStream baos = new ByteArrayStream(6 + this._transientSigningPublicKey.length());
        try {
            DataHelper.writeLong(baos, 4, this._transientExpires / 1000L);
            DataHelper.writeLong(baos, 2, this._transientSigningPublicKey.getType().getCode());
            this._transientSigningPublicKey.writeBytes(baos);
        }
        catch (IOException ioe) {
            return false;
        }
        catch (DataFormatException dfe) {
            return false;
        }
        return baos.verifySignature(ctx, this._offlineSignature, this.getSigningPublicKey());
    }

    public void setBlindedHash(Hash bh) {
        this._blindedHash = bh;
    }

    public Hash getBlindedHash() {
        return this._blindedHash;
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public void setSigningKey(SigningPublicKey key) {
        Log log = I2PAppContext.getGlobalContext().logManager().getLog(LeaseSet2.class);
        if (log.shouldWarn()) {
            log.warn("Don't set revocation key in ls2", new Exception("I did it"));
        }
    }

    @Override
    public boolean isCurrent(long fudge) {
        long now = Clock.getInstance().now();
        return this._expires > now - fudge;
    }

    @Override
    protected byte[] getBytes() {
        if (this._byteified != null) {
            return this._byteified;
        }
        if (this._destination == null) {
            return null;
        }
        int len = this.size();
        ByteArrayStream out = new ByteArrayStream(len);
        try {
            this.writeBytesWithoutSig(out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
            return null;
        }
        byte[] rv = out.toByteArray();
        if (this.getReceivedAsPublished()) {
            this._byteified = rv;
        }
        return rv;
    }

    @Override
    public void readBytes(InputStream in) throws DataFormatException, IOException {
        if (this._destination != null) {
            throw new IllegalStateException();
        }
        this.readHeader(in);
        this._options = DataHelper.readProperties(in, null);
        int numKeys = in.read();
        if (numKeys <= 0 || numKeys > 8) {
            throw new DataFormatException("Bad key count: " + numKeys);
        }
        if (numKeys > 1) {
            this._encryptionKeys = new ArrayList<PublicKey>(numKeys);
        }
        for (int i = 0; i < numKeys; ++i) {
            int encType = (int)DataHelper.readLong(in, 2);
            int encLen = (int)DataHelper.readLong(in, 2);
            if (encType == 0) {
                this._encryptionKey = PublicKey.create(in);
            } else {
                EncType type = EncType.getByCode(encType);
                byte[] encKey = new byte[encLen];
                DataHelper.read(in, encKey);
                this._encryptionKey = type != null ? new PublicKey(type, encKey) : new PublicKey(encType, encKey);
            }
            if (numKeys <= 1) continue;
            this._encryptionKeys.add(this._encryptionKey);
        }
        int numLeases = in.read();
        if (numLeases > 16) {
            throw new DataFormatException("Too many leases - max is 16");
        }
        for (int i = 0; i < numLeases; ++i) {
            Lease2 lease = new Lease2();
            ((Lease)lease).readBytes(in);
            super.addLease(lease);
        }
        SigType type = this.isOffline() ? this._transientSigningPublicKey.getType() : this._destination.getSigningPublicKey().getType();
        this._signature = new Signature(type);
        this._signature.readBytes(in);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._signature == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this.writeBytesWithoutSig(out);
        this._signature.writeBytes(out);
    }

    protected void writeBytesWithoutSig(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._encryptionKey == null) {
            throw new DataFormatException("Not enough data to write out a LeaseSet");
        }
        this.writeHeader(out);
        this.writeBody(out);
    }

    protected void writeBody(OutputStream out) throws DataFormatException, IOException {
        if (this._options != null && !this._options.isEmpty()) {
            DataHelper.writeProperties(out, this._options);
        } else {
            DataHelper.writeLong(out, 2, 0L);
        }
        List<PublicKey> keys = this.getEncryptionKeys();
        out.write((byte)keys.size());
        for (PublicKey key : keys) {
            EncType type = key.getType();
            if (type != null) {
                DataHelper.writeLong(out, 2, type.getCode());
            } else {
                DataHelper.writeLong(out, 2, key.getUnknownTypeCode());
            }
            DataHelper.writeLong(out, 2, key.length());
            key.writeBytes(out);
        }
        out.write((byte)this._leases.size());
        for (Lease lease : this._leases) {
            lease.writeBytes(out);
        }
    }

    protected void readHeader(InputStream in) throws DataFormatException, IOException {
        this._destination = Destination.create(in);
        this._published = DataHelper.readLong(in, 4) * 1000L;
        this._expires = this._published + DataHelper.readLong(in, 2) * 1000L;
        this._flags = (int)DataHelper.readLong(in, 2);
        if (this.isOffline()) {
            this.readOfflineBytes(in);
        }
    }

    protected void writeHeader(OutputStream out) throws DataFormatException, IOException {
        this._destination.writeBytes(out);
        if (this._published <= 0L) {
            this.setPublished(Clock.getInstance().now());
        }
        long pub1k = this._published / 1000L;
        DataHelper.writeLong(out, 4, pub1k);
        long exp = this._expires / 1000L - pub1k;
        if (exp < 0L) {
            throw new DataFormatException("Leaseset expired " + (0L - exp) + " seconds ago");
        }
        DataHelper.writeLong(out, 2, exp);
        DataHelper.writeLong(out, 2, this._flags);
        if (this.isOffline()) {
            this.writeOfflineBytes(out);
        }
    }

    protected void readOfflineBytes(InputStream in) throws DataFormatException, IOException {
        this._transientExpires = DataHelper.readLong(in, 4) * 1000L;
        int itype = (int)DataHelper.readLong(in, 2);
        SigType type = SigType.getByCode(itype);
        if (type == null) {
            throw new DataFormatException("Unknown sig type " + itype);
        }
        this._transientSigningPublicKey = new SigningPublicKey(type);
        this._transientSigningPublicKey.readBytes(in);
        SigType stype = this._destination.getSigningPublicKey().getType();
        this._offlineSignature = new Signature(stype);
        this._offlineSignature.readBytes(in);
    }

    protected void writeOfflineBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._transientSigningPublicKey == null || this._offlineSignature == null) {
            throw new DataFormatException("No offline key/sig");
        }
        DataHelper.writeLong(out, 4, this._transientExpires / 1000L);
        DataHelper.writeLong(out, 2, this._transientSigningPublicKey.getType().getCode());
        this._transientSigningPublicKey.writeBytes(out);
        this._offlineSignature.writeBytes(out);
    }

    @Override
    public int size() {
        int rv = this._destination.size() + 10 + this._leases.size() * 40;
        for (PublicKey key : this.getEncryptionKeys()) {
            rv += 4;
            rv += key.length();
        }
        if (this.isOffline()) {
            rv += 6 + this._transientSigningPublicKey.length() + this._offlineSignature.length();
        }
        if (this._options != null && !this._options.isEmpty()) {
            try {
                rv += DataHelper.toProperties(this._options).length;
            }
            catch (DataFormatException dfe) {
                throw new IllegalStateException("bad options", dfe);
            }
        } else {
            rv += 2;
        }
        return rv;
    }

    @Override
    public void addLease(Lease lease) {
        if (this.getType() == 3 && !(lease instanceof Lease2)) {
            throw new IllegalArgumentException();
        }
        super.addLease(lease);
        this._expires = this._lastExpiration;
    }

    @Override
    public void sign(SigningPrivateKey key) throws DataFormatException {
        if (this._signature != null) {
            throw new IllegalStateException();
        }
        if (key == null) {
            throw new DataFormatException("No signing key");
        }
        int len = this.size();
        ByteArrayStream out = new ByteArrayStream(1 + len);
        try {
            out.write(this.getType());
            this.writeBytesWithoutSig(out);
        }
        catch (IOException ioe) {
            throw new DataFormatException("Signature failed", ioe);
        }
        this._signature = out.sign(key);
        if (this._signature == null) {
            throw new DataFormatException("Signature failed with " + (Object)((Object)key.getType()) + " key");
        }
    }

    @Override
    public boolean verifySignature() {
        SigningPublicKey spk;
        if (this._signature == null) {
            return false;
        }
        SigType type = this._signature.getType();
        if (type == null || type.getBaseAlgorithm() == SigAlgo.RSA) {
            return false;
        }
        if (this.isOffline()) {
            type = this._transientSigningPublicKey.getType();
            if (type == null || type.getBaseAlgorithm() == SigAlgo.RSA) {
                return false;
            }
            if (!this.verifyOfflineSignature()) {
                return false;
            }
            spk = this._transientSigningPublicKey;
        } else {
            spk = this.getSigningPublicKey();
        }
        int len = this.size();
        ByteArrayStream out = new ByteArrayStream(1 + len);
        try {
            out.write(this.getType());
            this.writeBytesWithoutSig(out);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
        catch (DataFormatException dfe) {
            dfe.printStackTrace();
            return false;
        }
        return out.verifySignature(this._signature, spk);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof LeaseSet2)) {
            return false;
        }
        LeaseSet2 ls = (LeaseSet2)object;
        return DataHelper.eq(this._signature, ls.getSignature()) && DataHelper.eq(this._leases, ls._leases) && DataHelper.eq(this.getEncryptionKey(), ls.getEncryptionKey()) && DataHelper.eq(this._destination, ls.getDestination());
    }

    @Override
    public int hashCode() {
        if (this._destination == null) {
            return 0;
        }
        return this._destination.hashCode();
    }

    @Override
    public String toString() {
        int i;
        StringBuilder buf = new StringBuilder(128);
        buf.append("[LeaseSet2: ");
        if (this._destination != null) {
            buf.append("\n\tDestination: ").append(this._destination);
            buf.append("\n\tB32: ").append(this._destination.toBase32());
        }
        List<PublicKey> keys = this.getEncryptionKeys();
        int sz = keys.size();
        buf.append("\n\tEncryption Keys: ").append(sz);
        for (i = 0; i < sz; ++i) {
            buf.append("\n\tEncryption Key ").append(i).append(": ").append(keys.get(i));
        }
        if (this.isOffline()) {
            buf.append("\n\tTransient Key: ").append(this._transientSigningPublicKey);
            buf.append("\n\tTransient Expires: ").append(new Date(this._transientExpires));
            buf.append("\n\tOffline Signature: ").append(this._offlineSignature);
        }
        buf.append("\n\tOptions: ").append(this._options != null ? this._options.size() : 0);
        if (this._options != null && !this._options.isEmpty()) {
            for (Map.Entry<Object, Object> e : this._options.entrySet()) {
                String key = (String)e.getKey();
                String val = (String)e.getValue();
                buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
            }
        }
        buf.append("\n\tUnpublished? ").append(this.isUnpublished());
        buf.append("\n\tBlinded? ").append(this.isBlindedWhenPublished());
        buf.append("\n\tSignature: ").append(this._signature);
        buf.append("\n\tPublished: ").append(new Date(this._published));
        buf.append("\n\tExpires: ").append(new Date(this._expires));
        buf.append("\n\tLeases: #").append(this.getLeaseCount());
        for (i = 0; i < this.getLeaseCount(); ++i) {
            buf.append("\n\t\t").append(this.getLease(i));
        }
        buf.append("]");
        return buf.toString();
    }

    @Override
    public void encrypt(SessionKey key) {
        throw new UnsupportedOperationException();
    }
}

