/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.net.Socket;
import java.net.SocketTimeoutException;
import net.i2p.sam.UTF8Reader;

class ReadLine {
    private static final int MAX_LINE_LENGTH = 8192;

    ReadLine() {
    }

    public static void readLine(Socket socket, StringBuilder buf, int timeout) throws IOException {
        int c;
        long expires;
        int origTimeout = timeout;
        int i = 0;
        if (origTimeout > 0) {
            socket.setSoTimeout(timeout);
            expires = System.currentTimeMillis() + (long)timeout;
        } else {
            expires = 0L;
        }
        UTF8Reader reader = new UTF8Reader(socket.getInputStream());
        while ((c = ((Reader)reader).read()) != -1) {
            if (++i > 8192) {
                throw new LineTooLongException("Line too long - max 8192");
            }
            if (c == 10) break;
            if (origTimeout > 0) {
                int newTimeout = (int)(expires - System.currentTimeMillis());
                if (newTimeout <= 0) {
                    throw new SocketTimeoutException();
                }
                buf.append((char)c);
                if (newTimeout == timeout) continue;
                timeout = newTimeout;
                socket.setSoTimeout(timeout);
                continue;
            }
            buf.append((char)c);
        }
        if (c == -1) {
            if (origTimeout > 0 && System.currentTimeMillis() >= expires) {
                throw new SocketTimeoutException();
            }
            throw new EOFException();
        }
    }

    private static class LineTooLongException
    extends IOException {
        public LineTooLongException(String s) {
            super(s);
        }
    }
}

