/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.ldap;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.ldap.client.api.LdapNetworkConnection;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleServerException;
import org.apache.guacamole.auth.ldap.ConnectedLDAPConfiguration;
import org.apache.guacamole.auth.ldap.LDAPConnectionService;
import org.apache.guacamole.auth.ldap.conf.ConfigurationService;
import org.apache.guacamole.auth.ldap.conf.LDAPConfiguration;
import org.apache.guacamole.auth.ldap.group.UserGroupService;
import org.apache.guacamole.auth.ldap.user.LDAPAuthenticatedUser;
import org.apache.guacamole.auth.ldap.user.LDAPUserContext;
import org.apache.guacamole.auth.ldap.user.UserLDAPConfiguration;
import org.apache.guacamole.auth.ldap.user.UserService;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.credentials.CredentialsInfo;
import org.apache.guacamole.net.auth.credentials.GuacamoleInvalidCredentialsException;
import org.apache.guacamole.token.TokenName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationProviderService {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationProviderService.class);
    public static final String LDAP_TOKEN_PREFIX = "LDAP_";
    private static final Pattern LDAP_USERNAME_DOMAIN = Pattern.compile("^(.+)\\\\.*$|^.*@(.+)$");
    private static final int LDAP_USERNAME_DOMAIN_DOWN_LEVEL_GROUP = 1;
    private static final int LDAP_USERNAME_DOMAIN_UPN_GROUP = 2;
    public static final String LDAP_DOMAIN_TOKEN = "LDAP_DOMAIN";
    @Inject
    private LDAPConnectionService ldapService;
    @Inject
    private ConfigurationService confService;
    @Inject
    private UserService userService;
    @Inject
    private UserGroupService userGroupService;
    @Inject
    private Provider<LDAPAuthenticatedUser> authenticatedUserProvider;
    @Inject
    private Provider<LDAPUserContext> userContextProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dn getUserBindDN(LDAPConfiguration config, String username) throws GuacamoleException {
        String searchBindLogon = config.getSearchBindDN();
        if (searchBindLogon != null) {
            LdapNetworkConnection searchConnection = this.ldapService.bindAs(config, searchBindLogon, config.getSearchBindPassword());
            if (searchConnection == null) {
                logger.error("Unable to bind using search DN \"{}\"", (Object)searchBindLogon);
                return null;
            }
            try {
                List<Dn> userDNs = this.userService.getUserDNs(config, searchConnection, username);
                if (userDNs.isEmpty()) {
                    Dn dn = null;
                    return dn;
                }
                if (userDNs.size() != 1) {
                    logger.warn("Multiple DNs possible for user \"{}\": {}", (Object)username, userDNs);
                    Dn dn = null;
                    return dn;
                }
                Dn dn = userDNs.get(0);
                return dn;
            }
            finally {
                searchConnection.close();
            }
        }
        return this.userService.deriveUserDN(config, username);
    }

    private UserLDAPConfiguration getLDAPConfiguration(String username, String password) throws GuacamoleException {
        Collection<? extends LDAPConfiguration> configs = this.confService.getLDAPConfigurations();
        if (configs.isEmpty()) {
            logger.info("Skipping LDAP authentication as no LDAP servers are configured.");
            return null;
        }
        for (LDAPConfiguration lDAPConfiguration : configs) {
            String translatedUsername = lDAPConfiguration.appliesTo(username);
            if (translatedUsername == null) {
                logger.debug("LDAP server \"{}\" does not match username \"{}\".", (Object)lDAPConfiguration.getServerHostname(), (Object)username);
                continue;
            }
            logger.debug("LDAP server \"{}\" matched username \"{}\" as \"{}\".", new Object[]{lDAPConfiguration.getServerHostname(), username, translatedUsername});
            Dn bindDn = this.getUserBindDN(lDAPConfiguration, translatedUsername);
            if (bindDn == null || bindDn.isEmpty()) {
                logger.info("Unable to determine DN of user \"{}\" using LDAP server \"{}\". Proceeding with next server...", (Object)username, (Object)lDAPConfiguration.getServerHostname());
                continue;
            }
            LdapNetworkConnection ldapConnection = this.ldapService.bindAs(lDAPConfiguration, bindDn.getName(), password);
            if (ldapConnection == null) {
                logger.info("Unable to bind as user \"{}\" against LDAP server \"{}\". Proceeding with next server...", (Object)username, (Object)lDAPConfiguration.getServerHostname());
                continue;
            }
            logger.info("User \"{}\" was successfully authenticated by LDAP server \"{}\".", (Object)username, (Object)lDAPConfiguration.getServerHostname());
            return new UserLDAPConfiguration(lDAPConfiguration, translatedUsername, bindDn, ldapConnection);
        }
        logger.info("User \"{}\" did not successfully authenticate against any LDAP server.", (Object)username);
        return null;
    }

    public LDAPAuthenticatedUser authenticateUser(Credentials credentials) throws GuacamoleException {
        String username = credentials.getUsername();
        String password = credentials.getPassword();
        if (username == null || username.isEmpty() || password == null || password.isEmpty()) {
            throw new GuacamoleInvalidCredentialsException("Anonymous bind is not currently allowed by the LDAP authentication provider.", CredentialsInfo.USERNAME_PASSWORD);
        }
        UserLDAPConfiguration config = this.getLDAPConfiguration(username, password);
        if (config == null) {
            throw new GuacamoleInvalidCredentialsException("Invalid login.", CredentialsInfo.USERNAME_PASSWORD);
        }
        try {
            Set<String> effectiveGroups = this.userGroupService.getParentUserGroupIdentifiers(config, config.getBindDN());
            LDAPAuthenticatedUser authenticatedUser = (LDAPAuthenticatedUser)((Object)this.authenticatedUserProvider.get());
            authenticatedUser.init(config, credentials, this.getUserTokens(config, credentials), effectiveGroups);
            return authenticatedUser;
        }
        catch (Error | RuntimeException | GuacamoleException e) {
            config.close();
            throw e;
        }
    }

    private String getUserDomain(Credentials credentials) {
        String username = credentials.getUsername();
        Matcher matcher = LDAP_USERNAME_DOMAIN.matcher(username);
        if (!matcher.find()) {
            return null;
        }
        String dlDomain = matcher.group(1);
        String upnDomain = matcher.group(2);
        assert (dlDomain == null || upnDomain == null);
        return dlDomain != null ? dlDomain : upnDomain;
    }

    private Map<String, String> getUserTokens(ConnectedLDAPConfiguration config, Credentials credentials) throws GuacamoleException {
        Collection<String> attrList = config.getAttributes();
        if (attrList.isEmpty()) {
            return Collections.emptyMap();
        }
        String[] attrArray = attrList.toArray(new String[attrList.size()]);
        HashMap<String, String> tokens = new HashMap<String, String>();
        try {
            Entry userEntry = config.getLDAPConnection().lookup(config.getBindDN(), attrArray);
            if (userEntry == null) {
                return Collections.emptyMap();
            }
            Collection attributes = userEntry.getAttributes();
            if (attributes == null) {
                return Collections.emptyMap();
            }
            for (Attribute attr : attributes) {
                tokens.put(TokenName.canonicalize((String)attr.getId(), (String)LDAP_TOKEN_PREFIX), attr.getString());
            }
        }
        catch (LdapException e) {
            throw new GuacamoleServerException("Could not query LDAP user attributes.", (Throwable)e);
        }
        String domainName = this.getUserDomain(credentials);
        if (domainName != null) {
            tokens.put(LDAP_DOMAIN_TOKEN, domainName);
        }
        return tokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LDAPUserContext getUserContext(AuthenticatedUser authenticatedUser) throws GuacamoleException {
        if (authenticatedUser instanceof LDAPAuthenticatedUser) {
            LDAPAuthenticatedUser ldapAuthenticatedUser = (LDAPAuthenticatedUser)authenticatedUser;
            try (ConnectedLDAPConfiguration config = ldapAuthenticatedUser.getLDAPConfiguration();){
                LDAPUserContext userContext = (LDAPUserContext)((Object)this.userContextProvider.get());
                userContext.init(ldapAuthenticatedUser);
                LDAPUserContext lDAPUserContext = userContext;
                return lDAPUserContext;
            }
        }
        return null;
    }
}

