// Generated by gmmproc 2.50.1 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_STREAMVOLUME_H
#define _GSTREAMERMM_STREAMVOLUME_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/streamvolume.h>
#include <glibmm/interface.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GstStreamVolume = struct _GstStreamVolume;
using GstStreamVolumeClass = struct _GstStreamVolumeClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gst
{ class StreamVolume_Class; } // namespace Gst
#endif // DOXYGEN_SHOULD_SKIP_THIS

namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var StreamVolumeFormat STREAM_VOLUME_FORMAT_LINEAR
 * Linear scale factor, 1.0 = 100%.
 * 
 *  @var StreamVolumeFormat STREAM_VOLUME_FORMAT_CUBIC
 * Cubic volume scale.
 * 
 *  @var StreamVolumeFormat STREAM_VOLUME_FORMAT_DB
 * Logarithmic volume scale (dB, amplitude not power).
 * 
 *  @enum StreamVolumeFormat
 * 
 * Different representations of a stream volume. gst_stream_volume_convert_volume()
 * allows to convert between the different representations.
 * 
 * Formulas to convert from a linear to a cubic or dB volume are
 * cbrt(val) and 20 * log10 (val).
 *
 * @ingroup gstreamermmEnums
 */
enum StreamVolumeFormat
{
  STREAM_VOLUME_FORMAT_LINEAR,
  STREAM_VOLUME_FORMAT_CUBIC,
  STREAM_VOLUME_FORMAT_DB
};


/** An interface for elements that provide a stream volume.
 * @ingroup GstInterfaces
 */


class StreamVolume : public Glib::Interface
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = StreamVolume;
  using CppClassType = StreamVolume_Class;
  using BaseObjectType = GstStreamVolume;
  using BaseClassType = GstStreamVolumeInterface;

  // noncopyable
  StreamVolume(const StreamVolume&) = delete;
  StreamVolume& operator=(const StreamVolume&) = delete;

private:
  friend class StreamVolume_Class;
  static CppClassType streamvolume_class_;

#endif /* DOXYGEN_SHOULD_SKIP_THIS */
protected:
  /**
   * You should derive from this class to use it.
   */
  StreamVolume();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  /** Called by constructors of derived classes. Provide the result of
   * the Class init() function to ensure that it is properly
   * initialized.
   *
   * @param interface_class The Class object for the derived type.
   */
  explicit StreamVolume(const Glib::Interface_Class& interface_class);

public:
  // This is public so that C++ wrapper instances can be
  // created for C instances of unwrapped types.
  // For instance, if an unexpected C type implements the C interface.
  explicit StreamVolume(GstStreamVolume* castitem);

protected:
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  StreamVolume(StreamVolume&& src) noexcept;
  StreamVolume& operator=(StreamVolume&& src) noexcept;

  ~StreamVolume() noexcept override;

  static void add_interface(GType gtype_implementer);

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstStreamVolume*       gobj()       { return reinterpret_cast<GstStreamVolume*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstStreamVolume* gobj() const { return reinterpret_cast<GstStreamVolume*>(gobject_); }

private:


public:
  
  /** @param format Gst::StreamVolumeFormat which should be returned.
   * @return The current stream volume as linear factor.
   */
  double get_volume(Gst::StreamVolumeFormat format);
  
  /** @param format Gst::StreamVolumeFormat of @a val.
   * @param val Linear volume factor that should be set.
   */
  void set_volume(Gst::StreamVolumeFormat format, double val);
  
  /** @return Returns <tt>true</tt> if the stream is muted.
   */
  bool get_mute();
  
  /** @param mute Mute state that should be set.
   */
  void set_mute(bool mute);
  
  /** @param from Gst::StreamVolumeFormat to convert from.
   * @param to Gst::StreamVolumeFormat to convert to.
   * @param val Volume in @a from format that should be converted.
   * @return The converted volume.
   */
  static double convert_volume(Gst::StreamVolumeFormat from, Gst::StreamVolumeFormat to, double val);

  // Properties:
  /** Mute the audio channel without changing the volume.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_mute() ;

/** Mute the audio channel without changing the volume.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_mute() const;

  /** Linear volume factor, 1.0=100%.
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< double > property_volume() ;

/** Linear volume factor, 1.0=100%.
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< double > property_volume() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::StreamVolume
   */
  Glib::RefPtr<Gst::StreamVolume> wrap(GstStreamVolume* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_STREAMVOLUME_H */

