/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.DefaultBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.process.internal.worker.request.Request;

public class RequestSerializer
implements Serializer<Request> {
    private final Serializer<Object> argSerializer;
    private final boolean skipIncomingArg;

    public RequestSerializer(Serializer<Object> argSerializer, boolean skipIncomingArg) {
        this.argSerializer = argSerializer;
        this.skipIncomingArg = skipIncomingArg;
    }

    public void write(Encoder encoder, Request request) throws Exception {
        encoder.encodeChunked(target -> {
            Object object = request.getArg();
            this.argSerializer.write(target, object);
        });
        encoder.writeLong(request.getBuildOperation().getId().getId());
        OperationIdentifier parentId = request.getBuildOperation().getParentId();
        if (parentId != null) {
            encoder.writeBoolean(true);
            encoder.writeLong(parentId.getId());
        } else {
            encoder.writeBoolean(false);
        }
    }

    public Request read(Decoder decoder) throws Exception {
        Object arg;
        if (this.skipIncomingArg) {
            decoder.skipChunked();
            arg = null;
        } else {
            arg = decoder.decodeChunked(arg_0 -> this.argSerializer.read(arg_0));
        }
        OperationIdentifier id = new OperationIdentifier(decoder.readLong());
        DefaultBuildOperationRef buildOperation = decoder.readBoolean() ? new DefaultBuildOperationRef(id, new OperationIdentifier(decoder.readLong())) : new DefaultBuildOperationRef(id, null);
        return new Request(arg, (BuildOperationRef)buildOperation);
    }
}

