/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.cc.impl.serialize.DefaultClassEncoder;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0000\"\u001c\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\f"}, d2={"gradleRuntimeClassLoader", "Ljava/lang/ClassLoader;", "kotlin.jvm.PlatformType", "getGradleRuntimeClassLoader", "()Ljava/lang/ClassLoader;", "classForName", "Ljava/lang/Class;", "name", "", "classLoader", "classLoaderString", "describeClassLoader", "configuration-cache"})
public final class ClassLoadingKt {
    private static final ClassLoader gradleRuntimeClassLoader = DefaultClassEncoder.class.getClassLoader();

    public static final ClassLoader getGradleRuntimeClassLoader() {
        return gradleRuntimeClassLoader;
    }

    @NotNull
    public static final Class<?> classForName(@NotNull String name, @NotNull ClassLoader classLoader) {
        Class<?> clazz;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        try {
            Class<?> clazz2 = Class.forName(name, false, classLoader);
            Intrinsics.checkNotNullExpressionValue(clazz2, (String)"{\n        Class.forName(\u2026false, classLoader)\n    }");
            clazz = clazz2;
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundException classNotFoundException;
            ClassNotFoundException $this$classForName_u24lambda_u240 = classNotFoundException = new ClassNotFoundException("Class '" + name + "' not found in " + ClassLoadingKt.describeClassLoader(classLoader) + '.');
            boolean bl = false;
            ExceptionsKt.addSuppressed((Throwable)$this$classForName_u24lambda_u240, (Throwable)e);
            throw (Throwable)classNotFoundException;
        }
        return clazz;
    }

    @NotNull
    public static final String describeClassLoader(@NotNull ClassLoader classLoader) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        if (classLoader == gradleRuntimeClassLoader) {
            StringBuilder stringBuilder = new StringBuilder().append("Gradle runtime ");
            ClassLoader classLoader2 = gradleRuntimeClassLoader;
            Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"gradleRuntimeClassLoader");
            string2 = stringBuilder.append(ClassLoadingKt.classLoaderString(classLoader2)).toString();
        } else {
            string2 = ClassLoadingKt.classLoaderString(classLoader);
        }
        return string2;
    }

    private static final String classLoaderString(ClassLoader classLoader) {
        return "class loader '" + classLoader + "' of type '" + classLoader.getClass().getName() + '\'';
    }
}

