/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import org.gradle.api.internal.tasks.BaseFilePropertyVisitState;
import org.gradle.api.internal.tasks.properties.InputFilePropertySpec;
import org.gradle.api.internal.tasks.properties.PropertySpec;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.DirectorySnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotHierarchyVisitor;
import org.gradle.operations.execution.FilePropertyVisitor;

public class FilePropertyVisitState
extends BaseFilePropertyVisitState
implements FilePropertyVisitor.VisitState {
    private final FilePropertyVisitor visitor;

    private FilePropertyVisitState(FilePropertyVisitor visitor, Map<String, InputFilePropertySpec> propertySpecsByName) {
        super(propertySpecsByName);
        this.visitor = visitor;
    }

    public static void visitInputFileProperties(ImmutableSortedMap<String, CurrentFileCollectionFingerprint> inputFileProperties, FilePropertyVisitor visitor, Set<InputFilePropertySpec> inputFilePropertySpecs) {
        ImmutableMap propertySpecsByName = Maps.uniqueIndex(inputFilePropertySpecs, PropertySpec::getPropertyName);
        FilePropertyVisitState state = new FilePropertyVisitState(visitor, (Map<String, InputFilePropertySpec>)propertySpecsByName);
        for (Map.Entry entry : inputFileProperties.entrySet()) {
            CurrentFileCollectionFingerprint fingerprint = (CurrentFileCollectionFingerprint)entry.getValue();
            state.propertyName = (String)entry.getKey();
            state.propertyHash = fingerprint.getHash();
            state.fingerprints = fingerprint.getFingerprints();
            visitor.preProperty((FilePropertyVisitor.VisitState)state);
            fingerprint.getSnapshot().accept((FileSystemSnapshotHierarchyVisitor)state);
            visitor.postProperty();
        }
    }

    @Override
    protected void preRoot() {
        this.visitor.preRoot((FilePropertyVisitor.VisitState)this);
    }

    @Override
    protected void postRoot() {
        this.visitor.postRoot();
    }

    @Override
    protected void preDirectory() {
        this.visitor.preDirectory((FilePropertyVisitor.VisitState)this);
    }

    @Override
    protected void preUnvisitedDirectory(DirectorySnapshot unvisited) {
        this.visitor.preDirectory(new BaseFilePropertyVisitState.DirectoryVisitState<FilePropertyVisitState>(unvisited, this));
    }

    @Override
    protected void postDirectory() {
        this.visitor.postDirectory();
    }

    @Override
    protected void file() {
        this.visitor.file((FilePropertyVisitor.VisitState)this);
    }
}

