/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import com.google.common.collect.Iterators;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.FileCollectionExecutionTimeValue;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.util.internal.CollectionUtils;

public class FilteredFileCollection
extends AbstractFileCollection {
    private final FileCollectionInternal collection;
    private final Spec<? super File> filterSpec;

    public FilteredFileCollection(AbstractFileCollection collection, Spec<? super File> filterSpec) {
        super(collection.taskDependencyFactory, collection.patternSetFactory);
        this.collection = collection;
        this.filterSpec = filterSpec;
    }

    @Override
    public FileCollectionInternal replace(FileCollectionInternal original, Supplier<FileCollectionInternal> supplier) {
        AbstractFileCollection newCollection = (AbstractFileCollection)this.collection.replace(original, supplier);
        if (newCollection == this.collection) {
            return this;
        }
        return newCollection.filter((Spec)this.filterSpec);
    }

    public FileCollectionInternal getCollection() {
        return this.collection;
    }

    public Spec<? super File> getFilterSpec() {
        return this.filterSpec;
    }

    @Override
    public String getDisplayName() {
        return this.collection.getDisplayName();
    }

    @Override
    public void visitDependencies(TaskDependencyResolveContext context) {
        this.collection.visitDependencies(context);
    }

    @Override
    public Set<File> getFiles() {
        return (Set)CollectionUtils.filter((Iterable)((Object)this.collection), new LinkedHashSet(), this.filterSpec);
    }

    @Override
    public boolean contains(File file) {
        return this.collection.contains(file) && this.filterSpec.isSatisfiedBy((Object)file);
    }

    @Override
    public Iterator<File> iterator() {
        return Iterators.filter((Iterator)this.collection.iterator(), arg_0 -> this.filterSpec.isSatisfiedBy(arg_0));
    }

    @Override
    public Optional<FileCollectionExecutionTimeValue> calculateExecutionTimeValue() {
        return this.collection.calculateExecutionTimeValue().map(fileCollectionExecutionTimeValue -> new FilteredExecutionTimeValue((FileCollectionExecutionTimeValue)fileCollectionExecutionTimeValue, this.filterSpec));
    }

    private static class FilteredExecutionTimeValue
    implements FileCollectionExecutionTimeValue {
        private final FileCollectionExecutionTimeValue source;
        private final Spec<? super File> filter;

        public FilteredExecutionTimeValue(FileCollectionExecutionTimeValue source, Spec<? super File> filter) {
            this.source = source;
            this.filter = filter;
        }

        @Override
        public FileCollectionInternal toFileCollection(FileCollectionFactory fileCollectionFactory) {
            return this.source.toFileCollection(fileCollectionFactory).filter((Spec)this.filter);
        }
    }
}

