/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AttributeBasedFileVisitDetails;
import org.gradle.api.internal.file.DefaultFileVisitDetails;
import org.gradle.api.internal.file.UnauthorizedFileVisitDetails;
import org.gradle.internal.file.Chmod;
import org.gradle.internal.file.Stat;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.internal.os.OperatingSystem;

public class AttributeBasedFileVisitDetailsFactory {
    public static FileVisitDetails getRootFileVisitDetails(Path path, RelativePath relativePath, @Nullable BasicFileAttributes attrs, AtomicBoolean stopFlag, FileSystem fileSystem) {
        File file = path.toFile();
        if (attrs == null) {
            return new UnauthorizedFileVisitDetails(file, relativePath);
        }
        if (attrs.isDirectory() && OperatingSystem.current() == OperatingSystem.WINDOWS) {
            return new DefaultFileVisitDetails(file, relativePath, stopFlag, (Chmod)fileSystem, (Stat)fileSystem);
        }
        return new AttributeBasedFileVisitDetails(file, relativePath, stopFlag, (Chmod)fileSystem, (Stat)fileSystem, attrs);
    }

    public static FileVisitDetails getRootFileVisitDetails(Path path, RelativePath relativePath, AtomicBoolean stopFlag, FileSystem fileSystem) {
        BasicFileAttributes attrs = AttributeBasedFileVisitDetailsFactory.getAttributes(path);
        return AttributeBasedFileVisitDetailsFactory.getRootFileVisitDetails(path, relativePath, attrs, stopFlag, fileSystem);
    }

    public static FileVisitDetails getFileVisitDetails(Path path, RelativePath parentPath, @Nullable BasicFileAttributes attrs, AtomicBoolean stopFlag, FileSystem fileSystem) {
        boolean isDirectory = attrs != null && attrs.isDirectory();
        RelativePath relativePath = parentPath.append(!isDirectory, new String[]{path.getFileName().toString()});
        return AttributeBasedFileVisitDetailsFactory.getRootFileVisitDetails(path, relativePath, attrs, stopFlag, fileSystem);
    }

    public static FileVisitDetails getFileVisitDetails(Path path, RelativePath parentPath, AtomicBoolean stopFlag, FileSystem fileSystem) {
        BasicFileAttributes attrs = AttributeBasedFileVisitDetailsFactory.getAttributes(path);
        return AttributeBasedFileVisitDetailsFactory.getFileVisitDetails(path, parentPath, attrs, stopFlag, fileSystem);
    }

    @Nullable
    private static BasicFileAttributes getAttributes(Path path) {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            try {
                return Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            }
            catch (IOException next) {
                return null;
            }
        }
    }
}

