/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.CacheOpenException;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheVisitor;
import org.gradle.cache.internal.DefaultPersistentDirectoryCache;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.serialize.Serializer;

public class DefaultCacheFactory
implements CacheFactory,
Closeable {
    private final Map<File, DirCacheReference> dirCaches = new HashMap<File, DirCacheReference>();
    private final FileLockManager lockManager;
    private final ExecutorFactory executorFactory;
    private final Lock lock = new ReentrantLock();

    public DefaultCacheFactory(FileLockManager fileLockManager, ExecutorFactory executorFactory) {
        this.lockManager = fileLockManager;
        this.executorFactory = executorFactory;
    }

    void onOpen(Object cache) {
    }

    void onClose(Object cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PersistentCache open(File cacheDir, String displayName, Map<String, ?> properties, LockOptions lockOptions, @Nullable Consumer<? super PersistentCache> initializer, CacheCleanupStrategy cacheCleanupStrategy) throws CacheOpenException {
        this.lock.lock();
        try {
            PersistentCache persistentCache = this.doOpen(cacheDir, displayName, properties, lockOptions, initializer, cacheCleanupStrategy);
            return persistentCache;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void visitCaches(CacheVisitor visitor) {
        this.dirCaches.values().stream().map(dirCacheReference -> ((DirCacheReference)dirCacheReference).cache).forEach(visitor::visit);
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            CompositeStoppable.stoppable(this.dirCaches.values()).stop();
        }
        finally {
            this.dirCaches.clear();
            this.lock.unlock();
        }
    }

    private PersistentCache doOpen(File cacheDir, String displayName, Map<String, ?> properties, LockOptions lockOptions, @Nullable Consumer<? super PersistentCache> initializer, CacheCleanupStrategy cacheCleanupStrategy) {
        DirCacheReference dirCacheReference = this.dirCaches.get(cacheDir);
        if (dirCacheReference == null) {
            DefaultPersistentDirectoryStore cache;
            if (!properties.isEmpty() || initializer != null) {
                Consumer<? super PersistentCache> initAction = initializer != null ? initializer : __ -> {};
                cache = new DefaultPersistentDirectoryCache(cacheDir, displayName, properties, lockOptions, initAction, cacheCleanupStrategy, this.lockManager, this.executorFactory);
            } else {
                cache = new DefaultPersistentDirectoryStore(cacheDir, displayName, lockOptions, cacheCleanupStrategy, this.lockManager, this.executorFactory);
            }
            cache.open();
            dirCacheReference = new DirCacheReference(cache, properties, lockOptions);
            this.dirCaches.put(cacheDir, dirCacheReference);
        } else {
            if (!lockOptions.equals(dirCacheReference.lockOptions)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different lock options.", cacheDir));
            }
            if (!properties.equals(dirCacheReference.properties)) {
                throw new IllegalStateException(String.format("Cache '%s' is already open with different properties.", cacheDir));
            }
        }
        return new ReferenceTrackingCache(dirCacheReference);
    }

    private class DirCacheReference
    implements Closeable {
        private final Map<String, ?> properties;
        private final LockOptions lockOptions;
        private final ReferencablePersistentCache cache;
        private final Set<ReferenceTrackingCache> references = new HashSet<ReferenceTrackingCache>();

        DirCacheReference(ReferencablePersistentCache cache, Map<String, ?> properties, LockOptions lockOptions) {
            this.cache = cache;
            this.properties = properties;
            this.lockOptions = lockOptions;
            DefaultCacheFactory.this.onOpen(cache);
        }

        public void addReference(ReferenceTrackingCache cache) {
            this.references.add(cache);
        }

        public void release(ReferenceTrackingCache cache) {
            DefaultCacheFactory.this.lock.lock();
            try {
                if (this.references.remove(cache) && this.references.isEmpty()) {
                    this.close();
                }
            }
            finally {
                DefaultCacheFactory.this.lock.unlock();
            }
        }

        @Override
        public void close() {
            DefaultCacheFactory.this.onClose(this.cache);
            DefaultCacheFactory.this.dirCaches.values().remove(this);
            this.references.clear();
            this.cache.close();
        }
    }

    private static class ReferenceTrackingCache
    implements PersistentCache {
        private final DirCacheReference reference;

        private ReferenceTrackingCache(DirCacheReference reference) {
            this.reference = reference;
            reference.addReference(this);
        }

        public String toString() {
            return this.reference.cache.toString();
        }

        @Override
        public void close() {
            this.reference.release(this);
        }

        @Override
        public String getDisplayName() {
            return this.reference.cache.toString();
        }

        @Override
        public File getBaseDir() {
            return this.reference.cache.getBaseDir();
        }

        @Override
        public Collection<File> getReservedCacheFiles() {
            return this.reference.cache.getReservedCacheFiles();
        }

        @Override
        public <K, V> IndexedCache<K, V> createIndexedCache(IndexedCacheParameters<K, V> parameters) {
            return this.reference.cache.createIndexedCache(parameters);
        }

        @Override
        public <K, V> IndexedCache<K, V> createIndexedCache(String name, Class<K> keyType, Serializer<V> valueSerializer) {
            return this.reference.cache.createIndexedCache(name, keyType, valueSerializer);
        }

        @Override
        public <K, V> boolean indexedCacheExists(IndexedCacheParameters<K, V> parameters) {
            return this.reference.cache.indexedCacheExists(parameters);
        }

        @Override
        public <T> T withFileLock(Supplier<? extends T> action) {
            return this.reference.cache.withFileLock(action);
        }

        @Override
        public void withFileLock(Runnable action) {
            this.reference.cache.withFileLock(action);
        }

        @Override
        public <T> T useCache(Supplier<? extends T> action) {
            return this.reference.cache.useCache(action);
        }

        @Override
        public void useCache(Runnable action) {
            this.reference.cache.useCache(action);
        }

        @Override
        public void cleanup() {
            this.reference.cache.cleanup();
        }
    }
}

