/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;

public class RuleContext {
    private static final ThreadLocal<Deque<ModelRuleDescriptor>> STACK = ThreadLocal.withInitial(ArrayDeque::new);

    @Nullable
    public static ModelRuleDescriptor get() {
        return STACK.get().peek();
    }

    public static void run(ModelRuleDescriptor descriptor, Runnable runnable) {
        STACK.get().push(descriptor);
        try {
            runnable.run();
        }
        finally {
            STACK.get().pop();
        }
    }
}

