/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.Collections;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.console.RedrawableLabel;
import org.gradle.internal.logging.events.StyledTextOutputEvent;

public class DefaultRedrawableLabel
implements RedrawableLabel {
    private final Cursor writePos;
    private List<StyledTextOutputEvent.Span> spans = Collections.emptyList();
    private List<StyledTextOutputEvent.Span> writtenSpans = Collections.emptyList();
    private int absolutePositionRow;
    private int previousWriteRow = this.absolutePositionRow;
    private boolean isVisible;
    private boolean previousVisibility = this.isVisible = true;

    DefaultRedrawableLabel(Cursor writePos) {
        this.writePos = writePos;
    }

    @Override
    public void setText(String text) {
        this.spans = Collections.singletonList(new StyledTextOutputEvent.Span(text));
    }

    @Override
    public void setText(StyledTextOutputEvent.Span span) {
        this.spans = Collections.singletonList(span);
    }

    @Override
    public void setText(List<StyledTextOutputEvent.Span> spans) {
        this.spans = spans;
    }

    public Cursor getWritePosition() {
        return this.writePos;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public boolean isOverlappingWith(Cursor cursor) {
        return cursor.row == this.writePos.row && this.writePos.col > cursor.col;
    }

    @Override
    public void redraw(AnsiContext ansi) {
        if (this.writePos.row < 0) {
            return;
        }
        if (!this.isVisible && this.previousVisibility) {
            if (this.previousWriteRow == this.absolutePositionRow && this.writtenSpans.isEmpty()) {
                return;
            }
            this.writePos.col = 0;
            ansi.cursorAt(this.writePos).eraseAll();
            this.writtenSpans = Collections.emptyList();
        }
        if (this.isVisible) {
            if (this.previousWriteRow == this.absolutePositionRow && this.writtenSpans.equals(this.spans)) {
                return;
            }
            int writtenTextLength = this.writePos.col;
            this.writePos.col = 0;
            this.redrawText(ansi.writeAt(this.writePos), writtenTextLength);
            this.writtenSpans = this.spans;
            this.previousWriteRow = this.absolutePositionRow;
        }
    }

    private void redrawText(AnsiContext ansi, int writtenTextLength) {
        int textLength = 0;
        for (StyledTextOutputEvent.Span span : this.spans) {
            int length = span.getText().length();
            if (length <= 0) continue;
            ansi.withStyle(span.getStyle(), DefaultRedrawableLabel.writeText(span.getText()));
            textLength += length;
        }
        if (this.previousWriteRow == this.absolutePositionRow && textLength < writtenTextLength) {
            ansi.eraseForward();
        }
    }

    private static Action<AnsiContext> writeText(final String text) {
        return new Action<AnsiContext>(){

            public void execute(AnsiContext ansi) {
                ansi.a(text);
            }
        };
    }

    public void newLineAdjustment() {
        ++this.writePos.row;
    }

    public void scrollBy(int rows) {
        this.writePos.row -= rows;
        this.absolutePositionRow += rows;
    }

    public void scrollUpBy(int rows) {
        this.scrollBy(-rows);
    }

    public void scrollDownBy(int rows) {
        this.scrollBy(rows);
    }
}

