/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.model.internal.type.ParameterizedTypeWrapper;
import org.gradle.model.internal.type.TypeWrapper;
import org.gradle.model.internal.type.WildcardWrapper;

class WildcardTypeWrapper
implements WildcardWrapper {
    private final TypeWrapper[] upperBounds;
    private final TypeWrapper[] lowerBounds;
    private final int hashCode;

    public WildcardTypeWrapper(TypeWrapper[] upperBounds, TypeWrapper[] lowerBounds, int hashCode) {
        this.upperBounds = upperBounds;
        this.lowerBounds = lowerBounds;
        this.hashCode = hashCode;
    }

    @Override
    public Class<?> getRawClass() {
        if (this.upperBounds.length > 0) {
            return this.upperBounds[0].getRawClass();
        }
        return Object.class;
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        return ParameterizedTypeWrapper.contains(this, wrapper);
    }

    @Override
    public TypeWrapper getUpperBound() {
        return this.upperBounds[0];
    }

    @Override
    @Nullable
    public TypeWrapper getLowerBound() {
        return this.lowerBounds.length > 0 ? this.lowerBounds[0] : null;
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        for (TypeWrapper upperBound : this.upperBounds) {
            upperBound.collectClasses(builder);
        }
        for (TypeWrapper lowerBound : this.lowerBounds) {
            lowerBound.collectClasses(builder);
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof WildcardTypeWrapper)) {
            return false;
        }
        WildcardTypeWrapper var2 = (WildcardTypeWrapper)o;
        return Arrays.equals(this.lowerBounds, var2.lowerBounds) && Arrays.equals(this.upperBounds, var2.upperBounds);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getRepresentation(true);
    }

    @Override
    public String getRepresentation(boolean full) {
        TypeWrapper[] bounds = this.lowerBounds;
        StringBuilder sb = new StringBuilder();
        if (this.lowerBounds.length > 0) {
            sb.append("? super ");
        } else if (this.upperBounds.length > 0 && !this.upperBounds[0].getRawClass().equals(Object.class)) {
            bounds = this.upperBounds;
            sb.append("? extends ");
        } else {
            return "?";
        }
        assert (bounds.length > 0);
        boolean first = true;
        for (TypeWrapper bound : bounds) {
            if (!first) {
                sb.append(" & ");
            }
            first = false;
            sb.append(bound.getRepresentation(full));
        }
        return sb.toString();
    }
}

