/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.Closeable;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.IndexedCache;
import org.gradle.cache.IndexedCacheParameters;
import org.gradle.cache.ObjectHolder;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.InMemoryCacheDecoratorFactory;
import org.gradle.cache.scopes.BuildScopedCacheBuilderFactory;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.language.nativeplatform.internal.incremental.CompilationState;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateCacheFactory;
import org.gradle.language.nativeplatform.internal.incremental.CompilationStateSerializer;

@ServiceScope(value={Scope.Build.class})
public class DefaultCompilationStateCacheFactory
implements CompilationStateCacheFactory,
Closeable {
    private final IndexedCache<String, CompilationState> compilationStateIndexedCache;
    private final PersistentCache cache;

    public DefaultCompilationStateCacheFactory(BuildScopedCacheBuilderFactory cacheBuilderFactory, InMemoryCacheDecoratorFactory inMemoryCacheDecoratorFactory) {
        this.cache = cacheBuilderFactory.createCacheBuilder("nativeCompile").withDisplayName("native compile cache").withInitialLockMode(FileLockManager.LockMode.OnDemand).open();
        IndexedCacheParameters parameters = IndexedCacheParameters.of((String)"nativeCompile", String.class, (Serializer)new CompilationStateSerializer()).withCacheDecorator(inMemoryCacheDecoratorFactory.decorator(2000, false));
        this.compilationStateIndexedCache = this.cache.createIndexedCache(parameters);
    }

    @Override
    public void close() {
        this.cache.close();
    }

    @Override
    public ObjectHolder<CompilationState> create(String taskPath) {
        return new SimplePersistentObjectHolder(taskPath, this.compilationStateIndexedCache);
    }

    private static class SimplePersistentObjectHolder
    implements ObjectHolder<CompilationState> {
        private final String taskPath;
        private final IndexedCache<String, CompilationState> compilationStateIndexedCache;

        SimplePersistentObjectHolder(String taskPath, IndexedCache<String, CompilationState> compilationStateIndexedCache) {
            this.taskPath = taskPath;
            this.compilationStateIndexedCache = compilationStateIndexedCache;
        }

        public CompilationState get() {
            return (CompilationState)this.compilationStateIndexedCache.getIfPresent((Object)this.taskPath);
        }

        public void set(CompilationState newValue) {
            this.compilationStateIndexedCache.put((Object)this.taskPath, (Object)newValue);
        }

        public CompilationState update(ObjectHolder.UpdateAction<CompilationState> updateAction) {
            throw new UnsupportedOperationException();
        }

        public CompilationState maybeUpdate(ObjectHolder.UpdateAction<CompilationState> updateAction) {
            throw new UnsupportedOperationException();
        }
    }
}

