/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.continuous;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gradle.deployment.internal.ContinuousExecutionGate;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.UncheckedException;

public class ContinuousBuildTriggerHandler {
    private final BuildCancellationToken cancellationToken;
    private final ContinuousExecutionGate continuousExecutionGate;
    private final CountDownLatch changeOrCancellationArrived = new CountDownLatch(1);
    private final CountDownLatch cancellationArrived = new CountDownLatch(1);
    private final Duration quietPeriod;
    private volatile Instant lastChangeAt = ContinuousBuildTriggerHandler.nowFromMonotonicClock();
    private volatile boolean changeArrived;

    public ContinuousBuildTriggerHandler(BuildCancellationToken cancellationToken, ContinuousExecutionGate continuousExecutionGate, Duration continuousBuildQuietPeriod) {
        this.cancellationToken = cancellationToken;
        this.continuousExecutionGate = continuousExecutionGate;
        this.quietPeriod = continuousBuildQuietPeriod;
    }

    public void wait(Runnable notifier) {
        Runnable cancellationHandler = () -> {
            this.changeOrCancellationArrived.countDown();
            this.cancellationArrived.countDown();
        };
        if (this.cancellationToken.isCancellationRequested()) {
            return;
        }
        try {
            this.cancellationToken.addCallback(cancellationHandler);
            notifier.run();
            this.changeOrCancellationArrived.await();
            while (!this.cancellationToken.isCancellationRequested()) {
                Instant now = ContinuousBuildTriggerHandler.nowFromMonotonicClock();
                Instant endOfQuietPeriod = this.lastChangeAt.plus(this.quietPeriod);
                if (!endOfQuietPeriod.isAfter(now)) break;
                Duration remainingQuietPeriod = Duration.between(now, endOfQuietPeriod);
                this.cancellationArrived.await(remainingQuietPeriod.toMillis(), TimeUnit.MILLISECONDS);
            }
            if (!this.cancellationToken.isCancellationRequested()) {
                this.continuousExecutionGate.waitForOpen();
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
        finally {
            this.cancellationToken.removeCallback(cancellationHandler);
        }
    }

    public boolean hasBeenTriggered() {
        return this.changeArrived;
    }

    public void notifyFileChangeArrived() {
        this.changeArrived = true;
        this.lastChangeAt = ContinuousBuildTriggerHandler.nowFromMonotonicClock();
        this.changeOrCancellationArrived.countDown();
    }

    private static Instant nowFromMonotonicClock() {
        return Instant.ofEpochMilli(TimeUnit.NANOSECONDS.toMillis(System.nanoTime()));
    }
}

