/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestFrameworkDistributionModule;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.junit.JUnitDetector;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassProcessorFactory;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.junit.JUnitOptions;
import org.gradle.internal.Factory;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class JUnitTestFramework
implements TestFramework {
    private static final Logger LOGGER = Logging.getLogger(JUnitTestFramework.class);
    private static final List<TestFrameworkDistributionModule> DISTRIBUTION_MODULES = Collections.singletonList(new TestFrameworkDistributionModule("junit", Pattern.compile("junit-4.*\\.jar"), "org.junit.runner.Runner"));
    private JUnitOptions options;
    private JUnitDetector detector;
    private final DefaultTestFilter filter;
    private final boolean useImplementationDependencies;
    private final Factory<File> testTaskTemporaryDir;
    private final Provider<Boolean> dryRun;

    public JUnitTestFramework(Test testTask, DefaultTestFilter filter, boolean useImplementationDependencies) {
        this(filter, useImplementationDependencies, new JUnitOptions(), (Factory<File>)testTask.getTemporaryDirFactory(), (Provider<Boolean>)testTask.getDryRun());
    }

    private JUnitTestFramework(DefaultTestFilter filter, boolean useImplementationDependencies, JUnitOptions options, Factory<File> testTaskTemporaryDir, Provider<Boolean> dryRun) {
        this.filter = filter;
        this.useImplementationDependencies = useImplementationDependencies;
        this.options = options;
        this.testTaskTemporaryDir = testTaskTemporaryDir;
        this.detector = new JUnitDetector(new ClassFileExtractionManager(testTaskTemporaryDir));
        this.dryRun = dryRun;
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        JUnitOptions copiedOptions = new JUnitOptions();
        copiedOptions.copyFrom(this.options);
        return new JUnitTestFramework((DefaultTestFilter)newTestFilters, this.useImplementationDependencies, copiedOptions, this.testTaskTemporaryDir, this.dryRun);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        this.validateOptions();
        return new JUnitTestClassProcessorFactory(new JUnitSpec(this.filter.toSpec(), this.options.getIncludeCategories(), this.options.getExcludeCategories(), ((Boolean)this.dryRun.get()).booleanValue()));
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> {
            workerProcessBuilder.sharedPackages(new String[]{"junit.framework"});
            workerProcessBuilder.sharedPackages(new String[]{"junit.extensions"});
            workerProcessBuilder.sharedPackages(new String[]{"org.junit"});
        };
    }

    @Override
    public List<TestFrameworkDistributionModule> getWorkerImplementationClasspathModules() {
        return DISTRIBUTION_MODULES;
    }

    @Override
    public boolean getUseDistributionDependencies() {
        return this.useImplementationDependencies;
    }

    @Override
    public JUnitOptions getOptions() {
        return this.options;
    }

    void setOptions(JUnitOptions options) {
        this.options = options;
    }

    @Override
    public JUnitDetector getDetector() {
        return this.detector;
    }

    @Override
    public void close() throws IOException {
        this.detector = null;
    }

    private void validateOptions() {
        HashSet intersection = Sets.newHashSet(this.options.getIncludeCategories());
        intersection.retainAll(this.options.getExcludeCategories());
        if (!intersection.isEmpty()) {
            if (intersection.size() == 1) {
                LOGGER.warn("The category '" + (String)intersection.iterator().next() + "' is both included and excluded.  This will result in the category being excluded, which may not be what was intended.  Please either include or exclude the category but not both.");
            } else {
                String allCategories = intersection.stream().sorted().map(s -> "'" + s + "'").collect(Collectors.joining(", "));
                LOGGER.warn("The categories " + allCategories + " are both included and excluded.  This will result in the categories being excluded, which may not be what was intended. Please either include or exclude the categories but not both.");
            }
        }
    }
}

