/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirOptInUsageBaseChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvedImport;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J)\u0010\r\u001a\u00020\u0007*\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "<init>", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkContainingClasses", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOptInImportsChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOptInImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1863#2,2:59\n*S KotlinDebug\n*F\n+ 1 FirOptInImportsChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOptInImportsChecker\n*L\n27#1:59,2\n*E\n"})
public final class FirOptInImportsChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirOptInImportsChecker INSTANCE = new FirOptInImportsChecker();

    private FirOptInImportsChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Iterable $this$forEach$iv = declaration.getImports();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirRegularClassSymbol expandedClassSymbol;
            KtSourceElement source;
            FirClassLikeSymbol<?> parentClassSymbol;
            ClassId resolvedParentClassId;
            FirImport firImport = (FirImport)element$iv;
            boolean bl = false;
            if (!(firImport instanceof FirResolvedImport) || ((FirResolvedImport)firImport).getSource() == null || ((FirResolvedImport)firImport).getResolvedParentClassId() == null || FirSymbolProviderKt.getSymbolProvider(context.getSession()).getClassLikeSymbolByClassId(resolvedParentClassId) == null) continue;
            FirClassLikeSymbol<?> firClassLikeSymbol = parentClassSymbol;
            if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
                INSTANCE.checkContainingClasses(parentClassSymbol, source, context, reporter);
                continue;
            }
            if (!(firClassLikeSymbol instanceof FirTypeAliasSymbol) || DeclarationUtilsKt.fullyExpandedClass(parentClassSymbol, context.getSession()) == null) continue;
            INSTANCE.checkContainingClasses(expandedClassSymbol, source, context, reporter);
        }
    }

    private final void checkContainingClasses(FirClassLikeSymbol<?> $this$checkContainingClasses, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        FirOptInImportsChecker firOptInImportsChecker = this;
        while (true) {
            Object object;
            if (FirOptInUsageBaseChecker.INSTANCE.isExperimentalMarker((FirClassLikeSymbol<?>)$this$checkContainingClasses, context.getSession())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getOPT_IN_MARKER_CAN_ONLY_BE_USED_AS_ANNOTATION_OR_ARGUMENT_IN_OPT_IN(), (DiagnosticContext)context, null, 8, null);
            }
            if ((object = ClassMembersKt.getContainingClassLookupTag($this$checkContainingClasses)) == null || (object = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, context.getSession())) == null) {
                return;
            }
            Object containingClassSymbol = object;
            FirOptInImportsChecker firOptInImportsChecker2 = firOptInImportsChecker;
            KtSourceElement ktSourceElement = source;
            CheckerContext checkerContext = context;
            DiagnosticReporter diagnosticReporter = reporter;
            firOptInImportsChecker = firOptInImportsChecker2;
            $this$checkContainingClasses = containingClassSymbol;
            source = ktSourceElement;
            context = checkerContext;
            reporter = diagnosticReporter;
        }
    }
}

