/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.cfa;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.VariableInitializationCheckProcessor;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirThisReference;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.QualifiedAccessNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J0\u0010\u000b\u001a\u00020\f*\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0014\u0010\u0014\u001a\u00020\n*\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0014J,\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u00172\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J,\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J,\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationCheckProcessor;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/VariableInitializationCheckProcessor;", "<init>", "()V", "filterProperties", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "isForInitialization", "", "reportCapturedInitialization", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "symbol", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "hasMatchingReceiver", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "reportUninitializedVariable", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/QualifiedAccessNode;", "reportNonInlineMemberValInitialization", "reportValReassignment", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirPropertyInitializationAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationCheckProcessor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n865#2,2:134\n*S KotlinDebug\n*F\n+ 1 FirPropertyInitializationAnalyzer.kt\norg/jetbrains/kotlin/fir/analysis/cfa/PropertyInitializationCheckProcessor\n*L\n77#1:134,2\n*E\n"})
public final class PropertyInitializationCheckProcessor
extends VariableInitializationCheckProcessor {
    @NotNull
    public static final PropertyInitializationCheckProcessor INSTANCE = new PropertyInitializationCheckProcessor();

    private PropertyInitializationCheckProcessor() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Set<FirVariableSymbol<?>> filterProperties(@NotNull VariableInitializationInfoData data, boolean isForInitialization) {
        void destination$iv;
        void $this$filterTo$iv;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Iterable iterable = data.getProperties();
        Collection collection = new LinkedHashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            FirVariableSymbol it = (FirVariableSymbol)element$iv;
            boolean bl = false;
            if (!(it instanceof FirPropertySymbol)) {
                String string2 = "Failed requirement.";
                throw new IllegalArgumentException(string2.toString());
            }
            if (!(FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)it, isForInitialization) || data.getConditionallyInitializedProperties().contains(it))) continue;
            destination$iv.add(element$iv);
        }
        return (Set)destination$iv;
    }

    @Override
    protected void reportCapturedInitialization(@NotNull VariableInitializationInfoData $this$reportCapturedInitialization, @NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)$this$reportCapturedInitialization, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticFactory1<FirPropertySymbol> capturedInitializationError = $this$reportCapturedInitialization.getReceiver() != null ? FirErrors.INSTANCE.getCAPTURED_MEMBER_VAL_INITIALIZATION() : FirErrors.INSTANCE.getCAPTURED_VAL_INITIALIZATION();
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), capturedInitializationError, symbol, (DiagnosticContext)context, null, 16, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasMatchingReceiver(@NotNull FirQualifiedAccessExpression $this$hasMatchingReceiver, @NotNull VariableInitializationInfoData data) {
        Intrinsics.checkNotNullParameter((Object)$this$hasMatchingReceiver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        FirExpression firExpression = $this$hasMatchingReceiver.getDispatchReceiver();
        FirExpression expression2 = firExpression != null ? FirExpressionUtilKt.unwrapSmartcastExpression(firExpression) : null;
        FirPureAbstractElement firPureAbstractElement = expression2 instanceof FirThisReceiverExpression ? (FirThisReceiverExpression)expression2 : null;
        if (Intrinsics.areEqual(firPureAbstractElement != null && (firPureAbstractElement = ((FirThisReceiverExpression)firPureAbstractElement).getCalleeReference()) != null ? ((FirThisReference)firPureAbstractElement).getBoundSymbol() : null, data.getReceiver())) return true;
        FirResolvedQualifier firResolvedQualifier = expression2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)expression2 : null;
        if (!Intrinsics.areEqual(firResolvedQualifier != null ? firResolvedQualifier.getSymbol() : null, data.getReceiver())) return false;
        return true;
    }

    @Override
    protected void reportUninitializedVariable(@NotNull DiagnosticReporter reporter, @NotNull QualifiedAccessNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getSource(), FirErrors.INSTANCE.getUNINITIALIZED_VARIABLE(), symbol, (DiagnosticContext)context, null, 16, null);
    }

    @Override
    protected void reportNonInlineMemberValInitialization(@NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(symbol instanceof FirPropertySymbol)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getNON_INLINE_MEMBER_VAL_INITIALIZATION(), symbol, (DiagnosticContext)context, null, 16, null);
    }

    @Override
    protected void reportValReassignment(@NotNull VariableAssignmentNode node, @NotNull FirVariableSymbol<?> symbol, @NotNull DiagnosticReporter reporter, @NotNull CheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)node.getFir().getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), symbol, (DiagnosticContext)context, null, 16, null);
    }
}

