/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.codegen.BooleanValue;
import org.jetbrains.kotlin.backend.jvm.codegen.MaterialValue;
import org.jetbrains.kotlin.codegen.BranchedValue;
import org.jetbrains.kotlin.codegen.NumberCompare;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.org.objectweb.asm.Label;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/NonIEEE754FloatComparison;", "Lorg/jetbrains/kotlin/backend/jvm/codegen/BooleanValue;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "op", "Lorg/jetbrains/kotlin/com/intellij/psi/tree/IElementType;", "a", "Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;", "b", "<init>", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lcom/intellij/psi/tree/IElementType;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;Lorg/jetbrains/kotlin/backend/jvm/codegen/MaterialValue;)V", "numberCompareOpcode", "", "invokeStaticComparison", "", "type", "Lorg/jetbrains/org/objectweb/asm/Type;", "jumpIfFalse", "target", "Lorg/jetbrains/org/objectweb/asm/Label;", "jumpIfTrue", "discard", "backend.jvm.codegen"})
public final class NonIEEE754FloatComparison
extends BooleanValue {
    @NotNull
    private final IrFunctionAccessExpression expression;
    @NotNull
    private final MaterialValue a;
    @NotNull
    private final MaterialValue b;
    private final int numberCompareOpcode;

    public NonIEEE754FloatComparison(@NotNull IrFunctionAccessExpression expression2, @NotNull IElementType op, @NotNull MaterialValue a, @NotNull MaterialValue b) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)op, (String)"op");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        super(a.getCodegen());
        this.expression = expression2;
        this.a = a;
        this.b = b;
        this.numberCompareOpcode = NumberCompare.Companion.getNumberCompareOpcode(op);
    }

    private final void invokeStaticComparison(Type type2) {
        Type type3 = type2;
        if (Intrinsics.areEqual((Object)type3, (Object)Type.FLOAT_TYPE)) {
            this.getMv().invokestatic("java/lang/Float", "compare", "(FF)I", false);
        } else if (Intrinsics.areEqual((Object)type3, (Object)Type.DOUBLE_TYPE)) {
            this.getMv().invokestatic("java/lang/Double", "compare", "(DD)I", false);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void jumpIfFalse(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.markLineNumber(this.expression);
        this.invokeStaticComparison(this.a.getType());
        this.getMv().visitJumpInsn(this.numberCompareOpcode, target);
    }

    @Override
    public void jumpIfTrue(@NotNull Label target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.markLineNumber(this.expression);
        this.invokeStaticComparison(this.a.getType());
        InstructionAdapter instructionAdapter = this.getMv();
        Integer n = BranchedValue.Companion.getNegatedOperations().get(this.numberCompareOpcode);
        Intrinsics.checkNotNull((Object)n);
        instructionAdapter.visitJumpInsn(((Number)n).intValue(), target);
    }

    @Override
    public void discard() {
        this.markLineNumber(this.expression);
        this.b.discard();
        this.a.discard();
    }
}

