/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.ArtifactVerificationOperation;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.writer.VerificationEntry;
import org.gradle.api.internal.artifacts.verification.verifier.DependencyVerificationConfiguration;
import org.gradle.internal.Factory;
import org.gradle.internal.component.external.model.ModuleComponentArtifactIdentifier;

class PgpEntry
extends VerificationEntry {
    private final Factory<File> signatureFile;
    private final Set<String> trustedKeys = new TreeSet<String>();
    private final AtomicBoolean requiresChecksums = new AtomicBoolean();
    private final Set<String> failed = Sets.newConcurrentHashSet();
    private final AtomicBoolean noSignature = new AtomicBoolean();
    private final AtomicBoolean hasSignatureFile = new AtomicBoolean();
    private final Set<String> keysDeclaredGlobally = new HashSet<String>();

    PgpEntry(ModuleComponentArtifactIdentifier id, ArtifactVerificationOperation.ArtifactKind artifactKind, File file, Factory<File> signatureFile) {
        super(id, artifactKind, file);
        this.signatureFile = () -> {
            File f = (File)signatureFile.create();
            boolean hasSig = f != null && f.exists();
            this.hasSignatureFile.set(hasSig);
            if (!hasSig) {
                this.requiresChecksums.set(true);
            }
            return f;
        };
    }

    @Override
    int getOrder() {
        return -1;
    }

    public Set<String> getTrustedKeys() {
        return this.trustedKeys;
    }

    public PgpEntry addVerifiedKey(String key) {
        this.trustedKeys.add(key);
        return this;
    }

    public Factory<File> getSignatureFile() {
        return this.signatureFile;
    }

    public void fail(String keyId) {
        this.requiresChecksums.set(true);
        this.failed.add(keyId);
    }

    public void missing() {
        this.requiresChecksums.set(true);
    }

    public void noSignatures() {
        this.requiresChecksums.set(true);
        this.noSignature.set(true);
    }

    public boolean isRequiringChecksums() {
        return this.requiresChecksums.get();
    }

    public boolean isFailed() {
        return !this.failed.isEmpty() || this.noSignature.get();
    }

    public Set<String> getFailed() {
        return this.failed;
    }

    public void keyDeclaredGlobally(String keyId) {
        this.keysDeclaredGlobally.add(keyId);
    }

    public boolean doesNotDeclareKeyGlobally(String keyId) {
        return !this.keysDeclaredGlobally.contains(keyId);
    }

    public boolean hasArtifactLevelKeys() {
        return !this.trustedKeys.equals(this.keysDeclaredGlobally);
    }

    public Set<String> getArtifactLevelKeys() {
        HashSet keys = Sets.newHashSet(this.trustedKeys);
        keys.removeAll(this.keysDeclaredGlobally);
        return keys;
    }

    public boolean hasSignatureFile() {
        return this.hasSignatureFile.get();
    }

    boolean checkAndMarkSatisfiedBy(DependencyVerificationConfiguration.TrustedKey trustedKey) {
        if (!this.trustedKeys.contains(trustedKey.getKeyId())) {
            return false;
        }
        boolean matches = trustedKey.matches(this.id);
        if (matches) {
            this.keyDeclaredGlobally(trustedKey.getKeyId());
        }
        return matches;
    }
}

