/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.HorizontalRule;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;

public class VlineAtom
extends Atom {
    private float a;
    private float b;
    private int d;

    public VlineAtom(int n) {
        this.d = n;
    }

    public void setHeight(float f) {
        this.a = f;
    }

    public void setShift(float f) {
        this.b = f;
    }

    public float getWidth(TeXEnvironment teXEnvironment) {
        if (this.d != 0) {
            float f = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
            return f * (float)(3 * this.d - 2);
        }
        return 0.0f;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        if (this.d != 0) {
            float f = teXEnvironment.getTeXFont().getDefaultRuleThickness(teXEnvironment.getStyle());
            HorizontalRule horizontalRule = new HorizontalRule(this.a, f, this.b);
            StrutBox strutBox = new StrutBox(2.0f * f, 0.0f, 0.0f, 0.0f);
            HorizontalBox horizontalBox = new HorizontalBox();
            for (int i = 0; i < this.d - 1; ++i) {
                horizontalBox.add(horizontalRule);
                horizontalBox.add(strutBox);
            }
            if (this.d > 0) {
                horizontalBox.add(horizontalRule);
            }
            return horizontalBox;
        }
        return new StrutBox(0.0f, 0.0f, 0.0f, 0.0f);
    }
}

