/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class PropertyUtils {
    private PropertyUtils() {
    }

    public static boolean isWindows() {
        return PropertyUtils.getSystemProperty("os.name").toLowerCase(Locale.ENGLISH).indexOf("windows") >= 0;
    }

    public static String getSystemProperty(final String name) {
        assert (name != null) : "name is null";
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            return AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(name);
                }
            });
        }
        return System.getProperty(name);
    }
}

