/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.mvn;

import org.aesh.command.CommandDefinition;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.cli.cmd.Table;
import org.jboss.galleon.cli.config.mvn.MavenConfig;
import org.jboss.galleon.cli.config.mvn.MavenRemoteRepository;

@CommandDefinition(name="get-info", description="Display maven configuration content")
public class MavenGetInfo
extends PmSessionCommand {
    @Override
    protected void runCommand(PmCommandInvocation session) throws CommandExecutionException {
        Table t = new Table("Configuration Item", "Value");
        MavenConfig config = session.getPmSession().getPmConfiguration().getMavenConfig();
        t.addLine("Maven xml settings", config.getSettings() == null ? "No settings file set" : config.getSettings().normalize().toString());
        t.addLine("Local repository", config.getLocalRepository().normalize().toString());
        t.addLine("Default release policy", config.getDefaultReleasePolicy());
        t.addLine("Default snapshot policy", config.getDefaultSnapshotPolicy());
        t.addLine("Enable release", "" + config.isReleaseEnabled());
        t.addLine("Enable snapshot", "" + config.isSnapshotEnabled());
        t.addLine("Offline", "" + config.isOffline());
        Table.Cell repositories = new Table.Cell(new String[0]);
        Table.Cell title = new Table.Cell("Remote repositories");
        if (config.getRemoteRepositories().isEmpty()) {
            repositories.addLine("None");
        } else {
            for (MavenRemoteRepository rep : session.getPmSession().getPmConfiguration().getMavenConfig().getRemoteRepositories()) {
                repositories.addLine(rep.getName());
                repositories.addLine(" url=" + rep.getUrl());
                repositories.addLine(" type=" + rep.getType());
                repositories.addLine(" release=" + (rep.getEnableRelease() == null ? config.isReleaseEnabled() : rep.getEnableRelease().booleanValue()));
                repositories.addLine(" releaseUpdatePolicy=" + (rep.getReleaseUpdatePolicy() == null ? config.getDefaultReleasePolicy() : rep.getReleaseUpdatePolicy()));
                repositories.addLine(" snapshot=" + (rep.getEnableSnapshot() == null ? config.isSnapshotEnabled() : rep.getEnableSnapshot().booleanValue()));
                repositories.addLine(" snapshotUpdatePolicy=" + (rep.getSnapshotUpdatePolicy() == null ? config.getDefaultSnapshotPolicy() : rep.getSnapshotUpdatePolicy()));
            }
        }
        t.addCellsLine(title, repositories);
        t.sort(Table.SortType.ASCENDANT);
        session.println(t.build());
    }
}

