/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class SetNationMessage
extends AttributeMessage {
    public static final String TAG = "setNation";
    private static final String PLAYER_TAG = "player";
    private static final String VALUE_TAG = "value";

    public SetNationMessage(Player player, Nation nation) {
        super(TAG, PLAYER_TAG, player == null ? null : player.getId(), VALUE_TAG, nation == null ? null : nation.getId());
    }

    public SetNationMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, PLAYER_TAG, VALUE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player player = this.getPlayer(game);
        Nation nation = this.getValue(game.getSpecification());
        if (player != null && nation != null) {
            player.setNation(nation);
            if (!freeColClient.isInGame()) {
                this.pgc(freeColClient).addPlayerHandler(List.of(player));
            }
        }
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        ServerGame game;
        Player other;
        if (serverPlayer == null) {
            logger.warning("setNation from unknown connection.");
        }
        if ((other = this.getPlayer(game = freeColServer.getGame())) != null && other != serverPlayer) {
            return serverPlayer.clientError("Player " + other.getId() + " set from " + serverPlayer.getId());
        }
        Specification spec = game.getSpecification();
        Nation nation = this.getValue(spec);
        if (nation == null || game.getNationOptions().getNations().get(nation) != NationOptions.NationState.AVAILABLE) {
            return serverPlayer.clientError((StringTemplate)StringTemplate.template("server.badNation").addName("%nation%", nation == null ? "null" : nation.getId()));
        }
        return this.pgc(freeColServer).setNation(serverPlayer, nation);
    }

    public Player getPlayer(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(PLAYER_TAG), Player.class);
    }

    public Nation getValue(Specification spec) {
        return spec.getNation(this.getStringAttribute(VALUE_TAG));
    }
}

