/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class NewTurnMessage
extends AttributeMessage {
    public static final String TAG = "newTurn";
    private static final String TURN_TAG = "turn";

    public NewTurnMessage(Turn turn) {
        super(TAG, TURN_TAG, String.valueOf(turn.getNumber()));
    }

    public NewTurnMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, TURN_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        int turn = this.getTurnNumber();
        if (turn < 0) {
            logger.warning("Invalid turn for newTurn: " + Integer.toString(turn));
            return;
        }
        this.igc(freeColClient).newTurnHandler(turn);
        this.clientGeneric(freeColClient);
    }

    public int getTurnNumber() {
        return this.getIntegerAttribute(TURN_TAG, 0);
    }
}

