/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;

public class GameEndedMessage
extends AttributeMessage {
    public static final String TAG = "gameEnded";
    private static final String HIGH_SCORE_TAG = "highScore";
    private static final String WINNER_TAG = "winner";

    public GameEndedMessage(Player winner, boolean highScore) {
        super(TAG, WINNER_TAG, winner.getId(), HIGH_SCORE_TAG, String.valueOf(highScore));
    }

    public GameEndedMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, WINNER_TAG, HIGH_SCORE_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Player winner = this.getWinner(game);
        String highScore = this.getScore();
        if (winner == null) {
            logger.warning("Invalid player for gameEnded");
            return;
        }
        FreeColDebugger.finishDebugRun(freeColClient, true);
        if (winner != freeColClient.getMyPlayer()) {
            return;
        }
        this.igc(freeColClient).gameEndedHandler(highScore);
    }

    public Player getWinner(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(WINNER_TAG), Player.class);
    }

    public String getScore() {
        return this.getStringAttribute(HIGH_SCORE_TAG);
    }
}

