/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MouseInfo;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalButtonUI;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColButton;
import net.sf.freecol.client.gui.panel.FreeColImageBorder;
import net.sf.freecol.client.gui.plaf.LAFUtilities;
import net.sf.freecol.common.util.ImageUtils;

public class FreeColButtonUI
extends MetalButtonUI {
    private boolean paintBackground;
    private PropertyChangeListener pcl;

    public static ComponentUI createUI(JComponent c) {
        return new FreeColButtonUI();
    }

    @Override
    public void installUI(final JComponent c) {
        super.installUI(c);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (FreeColButton.BUTTON_STYLE_PROPERTY_NAME.equals(evt.getPropertyName())) {
                    FreeColButtonUI.this.updateStyle(c, (FreeColButton.ButtonStyle)((Object)evt.getNewValue()));
                }
            }
        };
        c.addPropertyChangeListener(this.pcl);
        if (c instanceof FreeColButton) {
            this.updateStyle(c, ((FreeColButton)c).getButtonStyle());
        } else {
            this.updateStyle(c, (FreeColButton.ButtonStyle)((Object)c.getClientProperty(FreeColButton.BUTTON_STYLE_PROPERTY_NAME)));
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        c.removePropertyChangeListener(this.pcl);
    }

    protected void updateStyle(JComponent c, FreeColButton.ButtonStyle buttonStyle) {
        int padding = (int)(5.0f * FontLibrary.getFontScaling());
        if (buttonStyle == FreeColButton.ButtonStyle.IMPORTANT) {
            c.setBorder(BorderFactory.createCompoundBorder(FreeColImageBorder.buttonBorder, BorderFactory.createEmptyBorder(padding, padding, padding, padding)));
            c.setOpaque(true);
            this.paintBackground = true;
        } else if (buttonStyle == FreeColButton.ButtonStyle.TRANSPARENT) {
            c.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            c.setOpaque(false);
            this.paintBackground = false;
        } else {
            c.setBorder(BorderFactory.createCompoundBorder(FreeColImageBorder.simpleButtonBorder, BorderFactory.createEmptyBorder(padding, padding, padding, padding)));
            c.setOpaque(false);
            this.paintBackground = true;
        }
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        LAFUtilities.setProperties(g, c);
        if (c.isOpaque() || this.paintBackground) {
            ImageUtils.drawTiledImage(ImageLibrary.getButtonBackground(), g, c, null);
        }
        super.paint(g, c);
        AbstractButton a = (AbstractButton)c;
        if (a.isRolloverEnabled()) {
            Point p = MouseInfo.getPointerInfo().getLocation();
            SwingUtilities.convertPointFromScreen(p, c);
            boolean rollover = c.contains(p);
            if (rollover) {
                this.paintButtonPressed(g, (AbstractButton)c);
            }
        }
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton c) {
        if (c.isContentAreaFilled()) {
            Graphics2D g2d = (Graphics2D)g;
            Dimension size = c.getSize();
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, size.width, size.height);
            g2d.setComposite(oldComposite);
            g2d.setColor(oldColor);
        }
    }
}

