/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.plaf.FreeColComboBoxRenderer;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.StringTemplate;

public final class FindSettlementPanel
extends FreeColPanel
implements ListSelectionListener,
ItemListener {
    private static final Logger logger = Logger.getLogger(FindSettlementPanel.class.getName());
    private JComboBox<String> displayOptionBox;
    private final JList<Settlement> settlementList = new JList();

    public FindSettlementPanel(FreeColClient freeColClient) {
        super(freeColClient, null, new MigLayout("wrap 1", "[align center]", "[]30[]30[]"));
        this.settlementList.setCellRenderer(new SettlementRenderer(this.getImageLibrary()));
        this.settlementList.setFixedCellHeight(48);
        this.settlementList.addListSelectionListener(this);
        this.settlementList.setSelectionMode(0);
        AbstractAction selectAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindSettlementPanel.this.selectSettlement();
            }
        };
        this.settlementList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.settlementList.getActionMap().put("select", selectAction);
        AbstractAction quitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindSettlementPanel.this.getGUI().removeComponent(FindSettlementPanel.this);
            }
        };
        this.settlementList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.settlementList.getActionMap().put("quit", quitAction);
        this.settlementList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    FindSettlementPanel.this.selectSettlement();
                }
            }
        });
        JScrollPane listScroller = new JScrollPane(this.settlementList);
        listScroller.setPreferredSize(new Dimension(250, 250));
        this.displayOptionBox = new JComboBox<String>(new String[]{Messages.message("findSettlementPanel.displayAll"), Messages.message("findSettlementPanel.displayOnlyNatives"), Messages.message("findSettlementPanel.displayOnlyEuropean")});
        this.displayOptionBox.addItemListener(this);
        this.add(Utility.localizedHeader(Messages.nameKey("findSettlementPanel"), Utility.FONTSPEC_SUBTITLE));
        this.add((Component)listScroller, "width max(300, 100%), height max(300, 100%)");
        this.add(this.displayOptionBox);
        this.add((Component)this.okButton, "tag ok");
        this.getGUI().restoreSavedSize(this, this.getPreferredSize());
        this.updateSearch(DisplayListOption.valueOf("ALL"));
        this.setEscapeAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                FindSettlementPanel.this.okButton.doClick();
            }
        });
    }

    private void updateSearch(DisplayListOption displayListOption) {
        DefaultListModel<Settlement> model = new DefaultListModel<Settlement>();
        Settlement selected = this.settlementList.getSelectedValue();
        for (Player player : this.getGame().getLivePlayerList(new Player[0])) {
            boolean ok;
            switch (displayListOption) {
                case ONLY_NATIVES: {
                    ok = player.isIndian();
                    break;
                }
                case ONLY_EUROPEAN: {
                    ok = player.isEuropean();
                    break;
                }
                case ALL: {
                    ok = true;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) continue;
            for (Settlement s : player.getSettlementList()) {
                model.addElement(s);
            }
        }
        this.settlementList.setModel(model);
        this.settlementList.setSelectedValue(selected, true);
        if (this.settlementList.getSelectedIndex() < 0) {
            this.settlementList.setSelectedIndex(0);
        }
    }

    private void selectSettlement() {
        Settlement settlement = this.settlementList.getSelectedValue();
        if (settlement instanceof Colony && settlement.getOwner() == this.getMyPlayer()) {
            this.getGUI().removeComponent(this);
            this.getGUI().showColonyPanel((Colony)settlement, null);
        } else if (settlement instanceof IndianSettlement) {
            this.getGUI().removeComponent(this);
            this.getGUI().showIndianSettlementPanel((IndianSettlement)settlement);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        switch (this.displayOptionBox.getSelectedIndex()) {
            default: {
                this.updateSearch(DisplayListOption.valueOf("ALL"));
                break;
            }
            case 1: {
                this.updateSearch(DisplayListOption.valueOf("ONLY_NATIVES"));
                break;
            }
            case 2: {
                this.updateSearch(DisplayListOption.valueOf("ONLY_EUROPEAN"));
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Settlement settlement = this.settlementList.getSelectedValue();
        if (settlement != null) {
            this.getGUI().setFocus(settlement.getTile());
        }
    }

    @Override
    public void requestFocus() {
        this.settlementList.requestFocus();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeAll();
        this.displayOptionBox = null;
    }

    private static enum DisplayListOption {
        ALL,
        ONLY_NATIVES,
        ONLY_EUROPEAN;

    }

    private static class SettlementRenderer
    extends FreeColComboBoxRenderer<Settlement> {
        private final ImageLibrary lib;

        public SettlementRenderer(ImageLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void setLabelValues(JLabel label, Settlement value) {
            Object template = ((StringTemplate)((StringTemplate)StringTemplate.template("findSettlementPanel.settlement").addName("%name%", value.getName())).addName("%capital%", value.isCapital() ? "*" : "")).addStringTemplate("%nation%", value.getOwner().getNationLabel());
            label.setText(Messages.message(template));
            label.setIcon(new ImageIcon(this.lib.getSettlementImage(value, new Dimension(64, -1))));
        }
    }
}

