/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.option;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.gui.GUI;
import net.sf.freecol.client.gui.option.BooleanOptionUI;
import net.sf.freecol.client.gui.option.FreeColActionUI;
import net.sf.freecol.client.gui.option.OptionUI;
import net.sf.freecol.client.gui.option.OptionUpdater;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.option.Option;
import net.sf.freecol.common.option.OptionGroup;

public final class OptionGroupUI
extends MigPanel
implements OptionUpdater,
TreeSelectionListener {
    private static final Logger logger = Logger.getLogger(OptionGroupUI.class.getName());
    private final List<OptionUpdater> optionUpdaters = new ArrayList<OptionUpdater>();
    private final HashMap<String, OptionUI> optionUIs = new HashMap();
    private final Map<String, TreeNode[]> optionGroupSelectionPath = new HashMap<String, TreeNode[]>();
    private final JPanel detailPanel;
    private final JTree tree;
    private final GUI gui;
    private final OptionGroup group;
    private final boolean editable;

    public OptionGroupUI(GUI gui, OptionGroup group, boolean editable) {
        super("ReportPanelUI", new MigLayout("fill"));
        this.gui = gui;
        this.group = group;
        this.editable = editable;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(group);
        this.buildTree(group, root);
        this.tree = new OptionTree(new DefaultTreeModel(root));
        this.tree.setOpaque(false);
        this.tree.addTreeSelectionListener(this);
        this.detailPanel = new MigPanel(new MigLayout("wrap 2, fillx", "[fill]related[fill]"));
        this.detailPanel.setOpaque(true);
        MigPanel treePanel = new MigPanel(new MigLayout("fill"));
        treePanel.add((Component)this.tree, "grow");
        JScrollPane treeScrollPane = new JScrollPane(treePanel, 20, 30);
        treeScrollPane.setOpaque(false);
        JScrollPane detailsScrollPane = new JScrollPane(this.detailPanel, 20, 30);
        detailsScrollPane.setOpaque(false);
        JSplitPane splitPane = new JSplitPane(1, treeScrollPane, detailsScrollPane);
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        this.add((Component)splitPane, "grow");
    }

    public JTree getTree() {
        return this.tree;
    }

    public void selectOption(String key) {
        Object[] path = this.optionGroupSelectionPath.get(key);
        if (path != null) {
            this.tree.setSelectionPath(new TreePath(path));
        }
    }

    private void buildTree(OptionGroup group, DefaultMutableTreeNode parent) {
        for (Option option : group.getOptions()) {
            if (!(option instanceof OptionGroup) || !((OptionGroup)option).isVisible()) continue;
            DefaultMutableTreeNode branch = new DefaultMutableTreeNode(option);
            parent.add(branch);
            this.buildTree((OptionGroup)option, branch);
            this.optionGroupSelectionPath.put(option.getId(), branch.getPath());
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        this.detailPanel.removeAll();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node != null) {
            if (node.isLeaf()) {
                OptionGroup group = (OptionGroup)node.getUserObject();
                for (Option option : group.getOptions()) {
                    this.addOptionUI(option, this.editable && group.isEditable());
                }
            } else {
                this.tree.expandPath(event.getPath());
            }
        }
        this.detailPanel.revalidate();
        this.detailPanel.repaint();
    }

    public void removeKeyStroke(KeyStroke keyStroke) {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            if (!(optionUpdater instanceof FreeColActionUI)) continue;
            ((FreeColActionUI)optionUpdater).removeKeyStroke(keyStroke);
        }
    }

    public OptionUI getOptionUI(String key) {
        return this.optionUIs.get(key);
    }

    public <T extends OptionUI> T getOptionUI(String key, Class<T> clazz) {
        return (T)((OptionUI)clazz.cast(this.optionUIs.get(key)));
    }

    private void addOptionUI(Option option, boolean editable) {
        JLabel label;
        OptionUI ui = this.optionUIs.get(option.getId());
        if (ui == null) {
            ui = OptionUI.getOptionUI(this.gui, option, editable);
            if (ui == null) {
                logger.warning("Unknown option type: " + option.toString());
                return;
            }
            if (option.getEnabledBy() != null) {
                BooleanOptionUI enabler = (BooleanOptionUI)this.optionUIs.get(option.getEnabledBy());
                OptionUI theUI = ui;
                enabler.addActionListener(e -> theUI.initialize());
                ui.setEnabler(enabler);
            }
            if (ui instanceof FreeColActionUI) {
                ((FreeColActionUI)ui).setOptionGroupUI(this);
            }
            if (option.getId() != null) {
                this.optionUIs.put(option.getId(), ui);
            }
        }
        if ((label = ui.getJLabel()) == null) {
            this.detailPanel.add((Component)ui.getComponent(), "newline, span");
        } else {
            this.detailPanel.add(label);
            this.detailPanel.add(ui.getComponent());
        }
        if (this.group.isEditable()) {
            this.optionUpdaters.add(ui);
        }
    }

    @Override
    public void updateOption() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.updateOption();
        }
    }

    @Override
    public void reset() {
        for (OptionUpdater optionUpdater : this.optionUpdaters) {
            optionUpdater.reset();
        }
    }

    private static class OptionTree
    extends JTree {
        private static final Color bgColor = new Color(0, 0, 0, 1);

        public OptionTree(DefaultTreeModel dtm) {
            super(dtm);
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.getCellRenderer();
            renderer.setBackgroundNonSelectionColor(bgColor);
        }

        @Override
        public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Option option = (Option)node.getUserObject();
            return Messages.getName(option.getId());
        }
    }
}

