/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias.canonicalize;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import io.mola.galimatias.canonicalize.URLCanonicalizer;

public class StripPartCanonicalizer
implements URLCanonicalizer {
    private final Part part;

    public StripPartCanonicalizer(Part part) {
        this.part = part;
    }

    @Override
    public URL canonicalize(URL input) throws GalimatiasParseException {
        switch (this.part) {
            case USERNAME: {
                return input.withUsername(null);
            }
            case PASSWORD: {
                return input.withPassword(null);
            }
            case PORT: {
                return input.withPort(-1);
            }
            case PATH: {
                return input.withPath("/");
            }
            case QUERY: {
                return input.withQuery(null);
            }
            case FRAGMENT: {
                return input.withFragment(null);
            }
        }
        return input;
    }

    public static enum Part {
        USERNAME,
        PASSWORD,
        PORT,
        PATH,
        QUERY,
        FRAGMENT;

    }
}

