/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.model.ImageAttributeName;
import java.io.Serializable;

public class DescribeImageAttributeRequest
extends AmazonWebServiceRequest
implements Serializable {
    private Boolean dryRun;
    private String imageId;
    private String attribute;

    public DescribeImageAttributeRequest() {
    }

    public DescribeImageAttributeRequest(String imageId, String attribute) {
        this.setImageId(imageId);
        this.setAttribute(attribute);
    }

    public DescribeImageAttributeRequest(String imageId, ImageAttributeName attribute) {
        this.imageId = imageId;
        this.attribute = attribute.toString();
    }

    public Boolean isDryRun() {
        return this.dryRun;
    }

    public void setDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
    }

    public DescribeImageAttributeRequest withDryRun(Boolean dryRun) {
        this.dryRun = dryRun;
        return this;
    }

    public Boolean getDryRun() {
        return this.dryRun;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public DescribeImageAttributeRequest withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public void setAttribute(String attribute) {
        this.attribute = attribute;
    }

    public DescribeImageAttributeRequest withAttribute(String attribute) {
        this.attribute = attribute;
        return this;
    }

    public void setAttribute(ImageAttributeName attribute) {
        this.attribute = attribute.toString();
    }

    public DescribeImageAttributeRequest withAttribute(ImageAttributeName attribute) {
        this.attribute = attribute.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.isDryRun() != null) {
            sb.append("DryRun: " + this.isDryRun() + ",");
        }
        if (this.getImageId() != null) {
            sb.append("ImageId: " + this.getImageId() + ",");
        }
        if (this.getAttribute() != null) {
            sb.append("Attribute: " + this.getAttribute());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.isDryRun() == null ? 0 : this.isDryRun().hashCode());
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getAttribute() == null ? 0 : this.getAttribute().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageAttributeRequest)) {
            return false;
        }
        DescribeImageAttributeRequest other = (DescribeImageAttributeRequest)obj;
        if (other.isDryRun() == null ^ this.isDryRun() == null) {
            return false;
        }
        if (other.isDryRun() != null && !other.isDryRun().equals(this.isDryRun())) {
            return false;
        }
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getAttribute() == null ^ this.getAttribute() == null) {
            return false;
        }
        return other.getAttribute() == null || other.getAttribute().equals(this.getAttribute());
    }
}

