/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.map;

import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class AutoDetectSourceProcess {
    public final void process(String file) throws IOException {
        Path path = new File(file).toPath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    AutoDetectSourceProcess.this.onFile(file, true);
                    return FileVisitResult.CONTINUE;
                }
            });
        } else if (Files.isRegularFile(path, new LinkOption[0])) {
            this.onFile(path, true);
        }
    }

    void onFile(Path file, boolean unzip) throws IOException {
        String name;
        block20: {
            name = file.getFileName().toString().toLowerCase();
            if (unzip) {
                if (name.endsWith(".apk") || name.endsWith(".zip") || name.endsWith(".jar")) {
                    Throwable throwable = null;
                    Object var5_6 = null;
                    try (FileSystem fs = BaseCmd.openZip((Path)file);){
                        Path dex = fs.getPath("/", "classes.dex");
                        if (Files.exists(dex, new LinkOption[0])) {
                            this.onFile(dex, true);
                        } else {
                            for (Path root : fs.getRootDirectories()) {
                                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                                    @Override
                                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                                        AutoDetectSourceProcess.this.onFile(file, false);
                                        return FileVisitResult.CONTINUE;
                                    }
                                });
                            }
                        }
                        break block20;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (name.endsWith(".dex")) {
                    this.onDex(file);
                }
            }
        }
        if (name.endsWith(".class")) {
            this.onClass(file);
        } else if (name.endsWith(".j")) {
            this.onJasmin(file);
        } else if (name.endsWith(".smali")) {
            this.onSmali(file);
        }
    }

    protected void onDex(Path file) throws IOException {
    }

    protected void onClass(Path file) throws IOException {
    }

    protected void onSmali(Path file) throws IOException {
    }

    protected void onJasmin(Path file) throws IOException {
    }
}

