/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongConsumer;
import java.util.function.LongUnaryOperator;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private ContentListeners contentListeners;
    private Decoder decoder;
    private Throwable failure;
    private long demand;
    private boolean stalled;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void demand(long n) {
        if (n <= 0L) {
            throw new IllegalArgumentException("Invalid demand " + n);
        }
        boolean resume = false;
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.demand = MathUtils.cappedAdd(this.demand, n);
            if (this.stalled) {
                this.stalled = false;
                resume = true;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response demand={}/{}, resume={}", n, this.demand, resume);
            }
        }
        if (resume) {
            if (this.decoder != null) {
                this.decoder.resume();
            } else {
                this.receive();
            }
        }
    }

    protected long demand() {
        return this.demand(LongUnaryOperator.identity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long demand(LongUnaryOperator operator) {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.demand = operator.applyAsLong(this.demand);
            return this.demand;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasDemandOrStall() {
        HttpReceiver httpReceiver = this;
        synchronized (httpReceiver) {
            this.stalled = this.demand <= 0L;
            return !this.stalled;
        }
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState.get() == ResponseState.FAILURE;
    }

    protected void receive() {
    }

    protected boolean responseBegin(HttpExchange exchange) {
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpConversation conversation = exchange.getConversation();
        HttpResponse response = exchange.getResponse();
        HttpDestination destination = this.getHttpDestination();
        HttpClient client2 = destination.getHttpClient();
        ProtocolHandler protocolHandler = client2.findProtocolHandler(exchange.getRequest(), response);
        Response.Listener handlerListener = null;
        if (protocolHandler != null) {
            handlerListener = protocolHandler.getResponseListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response {} found protocol handler {}", response, protocolHandler);
            }
        }
        exchange.getConversation().updateResponseListeners(handlerListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response begin {}", response);
        }
        ResponseNotifier notifier = destination.getResponseNotifier();
        notifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.BEGIN)) {
            return true;
        }
        this.dispose();
        this.terminateResponse(exchange);
        return false;
    }

    protected boolean responseHeader(HttpExchange exchange, HttpField field) {
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse response = exchange.getResponse();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        boolean process2 = notifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
        if (process2) {
            response.getHeaders().add(field);
            HttpHeader fieldHeader = field.getHeader();
            if (fieldHeader != null) {
                switch (fieldHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        URI uri = exchange.getRequest().getURI();
                        if (uri == null) break;
                        this.storeCookie(uri, field);
                        break;
                    }
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADER)) {
            return true;
        }
        this.dispose();
        this.terminateResponse(exchange);
        return false;
    }

    protected void storeCookie(URI uri, HttpField field) {
        block3: {
            try {
                String value = field.getValue();
                if (value != null) {
                    HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                    header.put(field.getHeader().asString(), Collections.singletonList(value));
                    this.getHttpDestination().getHttpClient().getCookieManager().put(uri, header);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug(x);
            }
        }
    }

    protected boolean responseHeaders(HttpExchange exchange) {
        List<String> contentEncodings;
        if (!this.updateResponseState(ResponseState.BEGIN, ResponseState.HEADER, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", response, System.lineSeparator(), response.getHeaders().toString().trim());
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        List<Response.ResponseListener> responseListeners = exchange.getConversation().getResponseListeners();
        notifier.notifyHeaders(responseListeners, (Response)response);
        this.contentListeners = new ContentListeners(responseListeners);
        this.contentListeners.notifyBeforeContent(response);
        if (!this.contentListeners.isEmpty() && (contentEncodings = response.getHeaders().getCSV(HttpHeader.CONTENT_ENCODING.asString(), false)) != null && !contentEncodings.isEmpty()) {
            block0: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                for (String encoding2 : contentEncodings) {
                    if (!factory.getEncoding().equalsIgnoreCase(encoding2)) continue;
                    this.decoder = new Decoder(exchange, factory.newContentDecoder());
                    continue block0;
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADERS)) {
            boolean hasDemand = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers hasDemand={} {}", hasDemand, response);
            }
            return hasDemand;
        }
        this.dispose();
        this.terminateResponse(exchange);
        return false;
    }

    protected boolean responseContent(HttpExchange exchange, ByteBuffer buffer2, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", exchange.getResponse(), System.lineSeparator(), BufferUtil.toDetailString(buffer2));
        }
        if (this.demand() <= 0L) {
            callback.failed(new IllegalStateException("No demand for response content"));
            return false;
        }
        if (this.decoder == null) {
            return this.plainResponseContent(exchange, buffer2, callback);
        }
        return this.decodeResponseContent(buffer2, callback);
    }

    private boolean plainResponseContent(HttpExchange exchange, ByteBuffer buffer2, Callback callback) {
        if (!this.updateResponseState(ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
            callback.failed(new IllegalStateException("Invalid response state " + this.responseState));
            return false;
        }
        HttpResponse response = exchange.getResponse();
        if (this.contentListeners.isEmpty()) {
            callback.succeeded();
        } else {
            this.contentListeners.notifyContent(response, buffer2, callback);
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) {
            boolean hasDemand = this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content {}, hasDemand={}", response, hasDemand);
            }
            return hasDemand;
        }
        this.dispose();
        this.terminateResponse(exchange);
        return false;
    }

    private boolean decodeResponseContent(ByteBuffer buffer2, Callback callback) {
        return this.decoder.decode(buffer2, callback);
    }

    protected boolean responseSuccess(HttpExchange exchange) {
        if (!exchange.responseComplete(null)) {
            return false;
        }
        this.responseState.set(ResponseState.IDLE);
        this.reset();
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response success {}", response);
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifySuccess(listeners, (Response)response);
        if (exchange.getResponse().getStatus() == 100) {
            return true;
        }
        this.terminateResponse(exchange);
        return true;
    }

    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure " + exchange.getResponse(), failure);
        }
        if (exchange.responseComplete(failure)) {
            return this.abort(exchange, failure);
        }
        return false;
    }

    private void terminateResponse(HttpExchange exchange) {
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}", response);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}, notifying {}", this.failure == null ? "succeeded" : "failed", result, listeners);
            }
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    protected void reset() {
        this.cleanup();
    }

    protected void dispose() {
        assert (this.responseState.get() != ResponseState.TRANSIENT);
        this.cleanup();
    }

    private void cleanup() {
        this.contentListeners = null;
        if (this.decoder != null) {
            this.decoder.destroy();
        }
        this.decoder = null;
        this.demand = 0L;
        this.stalled = false;
    }

    public boolean abort(HttpExchange exchange, Throwable failure) {
        ResponseState current;
        do {
            if ((current = this.responseState.get()) != ResponseState.FAILURE) continue;
            return false;
        } while (!this.updateResponseState(current, ResponseState.FAILURE));
        boolean terminate = current != ResponseState.TRANSIENT;
        this.failure = failure;
        if (terminate) {
            this.dispose();
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response abort {} {} on {}: {}", response, exchange, this.getHttpChannel(), failure);
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyFailure(listeners, (Response)response, failure);
        if (terminate) {
            this.terminateResponse(exchange);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: response termination skipped, performed by helpers", new Object[0]);
        }
        return false;
    }

    private boolean updateResponseState(ResponseState from1, ResponseState from2, ResponseState to) {
        ResponseState current;
        while ((current = this.responseState.get()) == from1 || current == from2) {
            if (!this.updateResponseState(current, to)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("State update failed: [{},{}] -> {}: {}", new Object[]{from1, from2, to, current});
        }
        return false;
    }

    private boolean updateResponseState(ResponseState from, ResponseState to) {
        ResponseState current;
        while ((current = this.responseState.get()) == from) {
            if (!this.responseState.compareAndSet(current, to)) continue;
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, current});
        }
        return false;
    }

    public String toString() {
        return String.format("%s@%x(rsp=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.responseState, this.failure);
    }

    private static enum DecodeResult {
        DECODE,
        NEED_INPUT,
        ABORT;

    }

    private class Decoder
    implements Destroyable {
        private final HttpExchange exchange;
        private final ContentDecoder decoder;
        private ByteBuffer encoded;
        private Callback callback;

        private Decoder(HttpExchange exchange, ContentDecoder decoder) {
            this.exchange = exchange;
            this.decoder = Objects.requireNonNull(decoder);
        }

        private boolean decode(ByteBuffer encoded, Callback callback) {
            boolean needInput;
            this.encoded = encoded;
            this.callback = callback;
            HttpResponse response = this.exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoding {} with {}{}{}", response, this.decoder, System.lineSeparator(), BufferUtil.toDetailString(encoded));
            }
            if (!(needInput = this.decode())) {
                return false;
            }
            boolean hasDemand = HttpReceiver.this.hasDemandOrStall();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content decoded, hasDemand={} {}", hasDemand, response);
            }
            return hasDemand;
        }

        private boolean decode() {
            block4: {
                boolean hasDemand;
                do {
                    if (!HttpReceiver.this.updateResponseState(ResponseState.HEADERS, ResponseState.CONTENT, ResponseState.TRANSIENT)) {
                        this.callback.failed(new IllegalStateException("Invalid response state " + HttpReceiver.this.responseState));
                        return false;
                    }
                    DecodeResult result = this.decodeChunk();
                    if (!HttpReceiver.this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) break block4;
                    if (result == DecodeResult.NEED_INPUT) {
                        return true;
                    }
                    if (result == DecodeResult.ABORT) {
                        return false;
                    }
                    hasDemand = HttpReceiver.this.hasDemandOrStall();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Response content decoded chunk, hasDemand={} {}", hasDemand, this.exchange.getResponse());
                } while (hasDemand);
                return false;
            }
            HttpReceiver.this.dispose();
            HttpReceiver.this.terminateResponse(this.exchange);
            return false;
        }

        private DecodeResult decodeChunk() {
            try {
                ByteBuffer buffer2;
                while (!(buffer2 = this.decoder.decode(this.encoded)).hasRemaining()) {
                    if (this.encoded.hasRemaining()) continue;
                    this.callback.succeeded();
                    this.encoded = null;
                    this.callback = null;
                    return DecodeResult.NEED_INPUT;
                }
                ByteBuffer decoded = buffer2;
                HttpResponse response = this.exchange.getResponse();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response content decoded chunk {}{}{}", response, System.lineSeparator(), BufferUtil.toDetailString(decoded));
                }
                HttpReceiver.this.contentListeners.notifyContent(response, decoded, Callback.from(() -> this.decoder.release(decoded), this.callback::failed));
                return DecodeResult.DECODE;
            }
            catch (Throwable x) {
                this.callback.failed(x);
                return DecodeResult.ABORT;
            }
        }

        private void resume() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response content resume decoding {} with {}", this.exchange.getResponse(), this.decoder);
            }
            if (this.callback == null) {
                HttpReceiver.this.receive();
                return;
            }
            boolean needInput = this.decode();
            if (needInput) {
                HttpReceiver.this.receive();
            }
        }

        @Override
        public void destroy() {
            if (this.decoder instanceof Destroyable) {
                ((Destroyable)((Object)this.decoder)).destroy();
            }
        }
    }

    private class ContentListeners {
        private final Map<Object, Long> demands = new ConcurrentHashMap<Object, Long>();
        private final LongConsumer demand = HttpReceiver.this::demand;
        private final List<Response.DemandedContentListener> listeners;

        private ContentListeners(List<Response.ResponseListener> responseListeners) {
            this.listeners = new ArrayList<Response.DemandedContentListener>(responseListeners.size());
            responseListeners.stream().filter(Response.DemandedContentListener.class::isInstance).map(Response.DemandedContentListener.class::cast).forEach(this.listeners::add);
        }

        private boolean isEmpty() {
            return this.listeners.isEmpty();
        }

        private void notifyBeforeContent(HttpResponse response) {
            if (this.isEmpty()) {
                this.demand.accept(1L);
            } else {
                ResponseNotifier notifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
                notifier.notifyBeforeContent(response, this::demand, this.listeners);
            }
        }

        private void notifyContent(HttpResponse response, ByteBuffer buffer2, Callback callback) {
            HttpReceiver.this.demand(d -> d - 1L);
            ResponseNotifier notifier = HttpReceiver.this.getHttpDestination().getResponseNotifier();
            notifier.notifyContent(response, this::demand, buffer2, callback, this.listeners);
        }

        private void demand(Object context, long value) {
            if (this.listeners.size() > 1) {
                this.accept(context, value);
            } else {
                this.demand.accept(value);
            }
        }

        private void accept(Object context, long value) {
            this.demands.merge(context, value, MathUtils::cappedAdd);
            if (this.demands.size() == this.listeners.size()) {
                long minDemand = Long.MAX_VALUE;
                for (Long demand : this.demands.values()) {
                    if (demand >= minDemand) continue;
                    minDemand = demand;
                }
                if (minDemand > 0L) {
                    Iterator<Map.Entry<Object, Long>> iterator = this.demands.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry<Object, Long> entry = iterator.next();
                        long newValue = entry.getValue() - minDemand;
                        if (newValue == 0L) {
                            iterator.remove();
                            continue;
                        }
                        entry.setValue(newValue);
                    }
                    this.demand.accept(minDemand);
                }
            }
        }
    }

    private static enum ResponseState {
        TRANSIENT,
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

