# Lore - CDDA Faction Lore and Design Document


#### Seriously, spoiler alert.
CDDA tells stories using unreliable narrators and a found footage style.  Knowing too much of the lore can ruin your experience.  Don't read this unless you plan to contribute, please!  If you do read this and don't plan to contribute, don't come complaining to me that it's not written in a compelling style, you're reading our napkin-notes my friend.

# CDDA Faction Lore and Design Goals: Deep Dive
This document will outline deep design concepts and lore for existing and planned factions, both human and alien.  Due to the infrequency of updates to design docs, I will not be distinguishing from what is planned for addition and what is already in the game; if something noted here is inconsistent with content in the game, it is worth checking with core developers to get an idea of which direction we plan to go in.

## Table of Contents

* [CDDA-Earth Native Human Factions](#CDDA-Earth-Native-Human-Factions)
* * [Free Merchants](#free-merchants)
* * [Hell's Raiders](#hells-raiders)
* * [Old Guard](#old-guard)
* * [Tacoma Commune](#tacoma-commune)
* * [Hub 01](#hub-01)
* * [Isherwood Farm](#isherwood-farm)
* * [New England Church Community](#New-England-Church-Community)
* [Extradimensional and Alien Factions](#extradimensional-and-alien-factions)
* * ["The Blob", XE-037](#the-blob-xe-037)
* * [The Mycus](#the-mycus)
* * [Triffids](#triffids)
* * [The Netherum](#the-netherum)
* * [The Exodii](#the-exodii)
* * [The Yrax](#the-yrax)
* * [Mi-Go](#mi-go)
* * [Hub 02](#hub-02)

## CDDA-Earth Native Human Factions

### Free Merchants

"A conglomeration of entrepreneurs and businessmen that stand together to hammer-out an existence through trade and industry."

#### Description
The Free Merchants are the remnants of "6 busloads of office workers and soccer moms" after the courageous people died fighting zombies.  The survivors want to fortify their evacuee center of a base and survive as a trading hub.

They have a lifeboat mentality at this point, and their lifeboat is full.  They are not charitable or nice and they pretty much require that people be able to pull their own weight or be abandoned.

#### Structure
The upper floor of the Evac Center is staffed by those physically able to defend themselves, work the caravans, et cetera.  The lower levels contain administrators, children, and key supports.  Also living upstairs are the "refugees", the last few people admitted to the faction before they realized the bunker was at capacity.

They're nominally a democracy on a town hall model.  However, realistically, an oligarchy has formed with some of the most vocal people who gained power in the chaos of the cataclysm.  These people have varying levels of support and competence and their voices are generally listened to the most in the group meetings.

##### Size
About 100 people, give or take.  Presumably people are regularly signing on as teamsters.
- Living full-time underground in the Free Merchant bunker are around 10 key support staff, another 30-50 children, and about 20 people who take care of the children.  A lot of the rest of the faction (another 40-60 people) sleeps there but spends more of their time above ground, guarding and helping with caravan duties.
- On the surface are around a dozen refugees that are technically part of the faction, but treated as second class citizens due to lacking a bunker bed.
- Teamsters consist of faction members as well as third party employees and contractors who are not part of the faction.  Those people would need other places to live, they can't be fit into the bunker.

#### Goals
Survive through trade.  Form friendly mutually beneficial relationships with other survivor factions.  Gain control over valuable resources and get other people to pay for them.

In the early to mid game, a key priority of the Merchants should be to build a self-sufficient defensible base.  While they don't require the player's aid for that, they may value the player as an experienced consultant.

#### Attitudes
Allied to the Old Guard as the last remnants of military force and organized government.  The Tacoma Commune is an allied off-shoot.  Trades with the Robofac, Exodii, random scavengers, New England Church Community, the Great Library, the Campus, the Brotherhood of the Tentacle, Strongarm Survivalists, Marloss Evangelists, and Fence Men.  Preyed on by the Hell's Raiders.  Distrusted by Isherwood Farm; would probably trade with them if they'd allow it.

Opposed to Mycus, triffids, zombies, and nether creatures, though has no ability to take the fight to them and can barely defend itself against zombie hordes.

Mildly anti-mutant.  Neither for or against augmentation.  Doesn't quite get that the Marloss Evangelists are mutants.

#### Bases
Controls the refugee center.  The Tacoma Commune is a farm project on a nearby ranch.

#### Trade/Economics
Has a robust internal economy, using specifically stamped US greenbacks as scrip called "Merch".  Honors their scrip, however it comes to them.  Will buy eCards at a huge discount and sell them at a significant discount.  Will buy money bundles at a premium (compared to their value as paper).

##### Player Trade
The Free Merchants should offer a wide variety of goods, implied to be brought in by scavengers and their caravans from looting the local area.  Canonically, they are low on food and should not trade a lot of that.  Otherwise, they should sell things that can be looted easily from the cities and surface buildings, with a specific focus on things that are annoying for the player to track down.

#### Missions
Deal with monsters and bandits, get parts for the center, help the Tacoma Commune.  Later, the merchants should be willing to hire you as a caravan guard, or to help meet and deal with external factions.

### Hell's Raiders

*"The largest gang of hooligans and bandits that preys upon other survivors.  Even if you have no gear, there is always a need for slaves and fresh meat."*

#### Description
The Hell's Raiders are a collection of smaller gangs, some of which existed before the Cataclysm.  Much of the membership was already willing to commit armed robbery or more violent crimes, and their attitudes haven't changed now that law enforcement is defunct and zombies roam the land.

#### Structure
Most gangs are led by a boss with an aptitude for leadership and violence.  The members consist of former criminals, along with some desperate people who figure having a rough bunch of thugs on your side is a good survival strategy.  Slaves round out the gang structure and perform menial labor, gardening, and other low risk but necessary work.

The gang leaders themselves are led by a junta of fairly nasty mutants and augmentees who view themselves as Nietzschean ubermensch with a Will to Power (not all of them take this view explicitly, but that's the general attitude).  They are the post-Human rulers of a brave new world.  Psychopathy is common, and at least a few are post-Threshold mutants with sapiovore.  At least some of these people were involved in creating the Cataclysm, though not intentionally.  Some of them are looking for other post- and trans-humans to serve as lieutenants.

#### Goals
The junta leadership seeks power and are willing to do what it takes to get it.  In their zero-sum worldview, other powerful factions mean less power for them, so they seek to destabilize the other factions, but they also seek to control or destroy monster factions like the Mycus, the triffids, and the mi-go.

Most gang members want to survive and be comfortable.

#### Size
Dozens of gangs.  Gangs range from 2-3 people to 40+.  The leadership junta has 4-7 members and fights among itself with some regularly and/or gets betrayed by ambitious underlings.

#### Attitudes
Hostile to the Old Guard, as the other remaining powerful human faction.  Individual gangs prey on the Free Merchants, Tacoma Commune, Farm Survivalists, Strongarm Survivalists, Gods Chosen, the Campus, and the Great Library.  Performs limited trade with the Robofac.  Generally friendly with Fence Men.  The leadership despises the Neo Natives but individual gangs sometimes trade with them.  Some gangs prey on the BOTT, but the leadership would prefer to recruit the more promising members.  Marloss Evangelists sometimes poach individual gangs or even junta members, but the junta can't quite decide if Marloss berries are a path to power or not.

Generally pro-mutant and pro-augmentation; post-Threshold mutants or powerful augmentees are more likely to be recruited than enslaved.

Generally hostile to the Mycus, triffids, zombies, and nether cults.

#### Bases
Individual gangs prefer to take over existing buildings, especially prepper cabins, LMOE shelters, apartments, or military outposts and bunkers.  Some gangs have built forts.  Any given lead has a base in a LMOE shelter, semi-functioning lab, or military outpost.

#### Trade/Economics
Has a fairly robust internal economic system based on precious metals, but no formal currency within the first year.  Favored allies (the Fence Men basically) can also trade gold/silver with them.  Other people get promissory notes to round out barter, with no guarantee that the promissory notes will be honored in the future.  The double-dealing nature of the Hell's Raiders will cause them problems in the future.

##### Player Trade
The Raiders should offer a wide variety of goods, implied to be stolen from scavengers and merchant caravans.  They should sell things that can be looted easily from the cities and surface buildings, with a specific focus on things that are annoying for the player to track down.  Despite their combat bent, they likely don't share their best guns too readily.

#### Missions
Spy on Free Merchant and Tacoma Commune caravans, subvert the Old Guard, destroy fungal infestations, destroy triffids.

#### Note
Current members of the Hell's Raiders shoot the player on sight, so if they're going to be developed as a real faction, that needs to change.

### Old Guard

"The remains of the federal government.  The extent of their strength is unknown but squads of patrolling soldiers have been seen under their banner."

#### Description
The Old Guard claims to be the remnants of the US Federal government, with an armada of ships in the Atlantic Ocean and a few walled off cities near the coast.  In practice, there's a pair of Old Guard agents at the Evacuee Center working with the Free Merchants, and a few squads caught in the Necropolis.

The Old Guard, on the surface, seems like the "good" faction, but they're making claims they can't support and are stretched way too thin.  Their leadership also caused the Cataclysm, so it's not obvious why anyone would want to put them back in control.

#### Structure
Practically speaking, the Old Guard is a support network that can provide limited supplies and goods to independent contractors and Federal Marshals who perform necessary tasks.

#### Goals
Undo the Cataclysm, or failing that, re-establish civilization under the Old Guard's control.

#### Size
Theoretically, tens of thousands of people.  Practically, a few dozen.

#### Attitudes
Friendly to any organization that accepts Old Guard guidance and seeks to stabilize the Cataclysm.  They're on good terms with the Free Merchants, Tacoma Commune, New England Church Community, the Great Library, and the Campus.  Opposed to the Fence Men, Hell's Raider, Neo-Natives, and Bravo Deserters.  Wants to establish control over the Strongarm Survivalists, Farm Survivalists, and Robofac, and would be willing to use force to settle the issue.  To the extent that the Old Guard understands that Marloss Evangelists are a front for the Mycus, they're against them.

Completely neutral on the subject of mutants and augmentees.

Explicitly hostile to the Mycus, triffids, zombies, and nether cults.

#### Bases
The Old Guard has outposts at the Evacuee Center.

#### Trade/Economics
The Old Guard is the US government, and thus thinks that trade should be handled via US greenbacks (money bundles) and eCash.  The reality of the Cataclysm means that there's been 1000% inflation, so while they technically honor eCash, they don't pay much for it.

##### Player Trade
At this time, the Old Guard is likely  not going to do a lot of direct trading with players.

#### Missions
Deal with bandits, investigate labs, rescue soldiers from the Necropolis, bring Farm/Strongarm Survivalists into the fold.

#### Resources
The key resource of the Old Guard is their fleets.  Due to the isolated, regimented and self-sufficient nature of naval vessels (including merchant vessels), there was a vastly higher survival rate among in-transit ships than among the general population.  While the fleets took losses from many sources, there are a number of fully-crewed and operational ships, including some very large vessels.  This resource comes at a great cost however, the manpower required to operate and maintain these vessels accounts for the majority of the Old Guard population, and the resources they require is an unsustainable drain on the faction.

#### Development Direction
The major challenge facing the old guard immediately after the Cataclysm is extracting as much value as possible from the fleet while decommissioning it.  Each remaining ship can either be operated as a combat vessel at great resource cost (food, equipment, provisions, fuel and manpower) or decommissioned to provide a core around which a community can be built.  Even the smallest ship has a large diesel engine that can be configured as a generator, as well as secured storage facilities, sleeping berths, stocks of ammunition and weapons, and various facilities such a cooking, machine shops and medical facilities.  The expected trajectory is that the Old Guard recruits survivors to act as settlers, and once they have a sufficient number and have located a strategic location for a settlement, they establish a settlement there and decommission a ship to act as the core of the settlement.  In parallel with this decommissioning effort, the Old Guard would prioritize establishing a provisional and then permanent government to maintain their legitimacy.

One possible ongoing campaign for the Old Guard might be clearing and forming a permanent zombie-free zone on Nantucket, then launching a similar campaign to attempt to retake Martha's Vineyard.  Player/mercenary involvement in the Martha's Vineyard campaign would be an option.

#### Steady State
Eventually the majority of the fleet is decommissioned as the cores of new settlements scattered across the eastern seaboard.  A remaining skeleton fleet, operating with skeleton crews might continue to patrol the Atlantic coast to provide support to these settlements.  The faction at this point is transitioned into expanding their control and solidifying their holdings.  Settlements built around a decommissioned ship have a massive head start compared to most settlements, but at the same time Old Guard settlers would be the least equipped among the factions to adapt to the new realities of founding an inshore settlement.

### Tacoma Commune

*"An outpost started by the Free Merchants to provide a source of food and raw materials."*

#### Description
The Free Merchants send their idle hands to work at the Tacoma Commune.  Hard work as a subsistence farmer at the Commune is unpleasant, but it's better than starving to death at the Evac Center, and Commune workers get first dibs on any food produced.

Over time, the interests of the Commune and Merchants are going to diverge, and the Commune workers are going to be less and less interested in paying taxes to the Free Merchant.

#### Structure
The foreman and crop overseer run the joint.

#### Goals
Build a small village at a ranch.

#### Size
2 people initially but increases over time.

#### Attitudes
A colony of the Free Merchants that initially takes their attitudes.

#### Bases
Controls a ranch.

#### Trade/Economics
Uses Free Merchant scrip for commerce, with substantial black market trading in cut logs and healthcare services.

##### Player Trade
Initially the Tacoma Commune doesn't have a lot to trade.  As they advance, they should be a great source of natural building materials like lumber, and a secondary source of fresh food sorted by season.

#### Missions
Acquire supplies necessary to expand the commune, help build the commune, defend caravans to the evac center.

### Hub 01

*"A holdover faction of scientists connected to the ones who may have caused the Cataclysm itself."*

#### Description
Hub01 is one of the computer science labs set up by XEDRA. It is the housing area for Melchior, XEDRA's experimental AI system, and thanks to Melchior, the staff were able to survive the Cataclysm mostly intact. Melchior itself became briefly sentient and hyperintelligent during the portal storms, but has now been returned to being a bit smarter than chatGPT.

#### Structure
This section is unfinished.
Most interaction with Hub01 will occur through the Ancillary Bar and mercenaries, a group of Hub-affiliated personnel who are not, in fact, members of the Hub.

#### Goals


#### Size


#### Attitudes


#### Bases


#### Trade/Economics


**Missions** 


### Isherwood Farm

*"Summary"*

#### Description


#### Structure


#### Goals


#### Size


#### Attitudes


#### Bases


#### Trade/Economics


#### Missions


### New England Church Community

*"A benign religious faction attempting to keep Christianity and the Teachings of Jesus alive for the following generations."*

#### Description - Background
Before the Cataclysm, the New England Church Community (NECC) was an ordinary congregation of American Evangelists with slight doomsday-cultish/end-of-the-world undertones.  Formed by the one they refer to as "The Founder", he believed that God was speaking to him through his dreams, and that he was being warned of an approaching apocalypse. He spread the word to his followers, who subsequently began preparing for the apocalypse.  They amassed many years' worth of canned foods and supplies to weather through what they named "the Second Flood".

The Founder died a few years before his prophecy came true. His eldest daughter, Helena, has since taken over running the sect, who sternly follows his father's principles.

#### Description - Beliefs
The NECC believes that God has punished all of humanity for their wickedness and let loose a temporary Hell on earth.

The followers of The Founder refer to the Cataclysm as "the Second Flood".  They see themselves as too worthy to have been left behind in the Rapture, so they've decided to name it after the Great Flood from the Book of Genesis.  In their eyes, the Second Flood, and the Great Flood both serve the same purpose – to cleanse earth of violence and the corrupt – the difference being that God let loose the Beasts of the Devil instead of making it rain for 40 days and 40 nights so as not to break the promise He made to Noah[^1] (the rich have yachts anyway). The NECC believes itself to be God's chosen, to whom He confided His intentions, and see their campground and stockpile as their metaphorical ark. They believe that the Cataclysm is only a temporary state.

[^1]: God made a covenant with Noah and promised never again to destroy all the Earth's creatures with a flood.

#### Structure
They are theoretically one based on equality, but in reality the Founder's eldest daughter Helena is the leader and has the most sway.

#### Goals
They believe that the Cataclysm is only a temporary state.

#### Size
22 people made up of a few religious leaders, their followers, and a few outsiders that stay around.

#### Attitudes
The NECC didn't expect outsiders to survive the Cataclysm, nevertheless they're generally friendly, but distant towards other survivors.  They are willing to offer shelter to anyone that needs it and are eager to trade medicinal herbs, raw materials, or small crafts for the right price. That's where their Good Samaritanism ends, however.

The NECC discriminates against anyone that's not part of their sect.  They are unwilling to let anyone in their "ark" – share their stockpile with outsiders or letting them join their congregation.  They put the blame on the victims for not joining their sect when they had the time – after all, the NECC did put out flyers urging people to join them while they still could.  Now the ark's gate has shut, and the rest must fend off for themselves.

They are strongly against anyone with bionics, or anyone who willingly mutated.

Knows of the Free Merchants and the Tacoma Commune and is friendly enough to trade, but like with all outsiders, keeps them at arms length.
Standoffish with the Isherwood Family.
Dislike the Old Guard (for being percieved as getting us into this mess) and any group that promotes bionics, mutations, or interactions with the nether creatures.
Hostile towards Hell's Raiders and Marloss Evangelists 

#### Bases
New England Church Retreat camp located in a forest.

#### Trade/Economics
Miscellaneous, tools, supplies, and pelts. They use their own form of currency based on religious icons to manage internal trade, which are virtually worthless to outsiders. As the Cataclysm wears on, they may gain enough economic power to be worth something.

#### Missions
Helping with various tasks around the camp, and later personal matters of the members. A trusted individual may be able to assist in outside politicking or spreading the word of God.


## Extradimensional and Alien Factions


### "The Blob", XE-037

**Discovery**: 
The blob came to CDDA-Earth as the consequence of scientists exploring dimensions without knowing the risks.  There may have been some encouragement from otherdimensional forces.  See [the Background document](./lore-background.md) for full details.

#### Description 
The Blob is a dispersed intelligence vastly greater than anything conceivable to a human mind.  To it, we are as significant as individual cells of a body.  Human researchers obtained samples of the Blob.  While XEDRA experimented on it, it passively observed them and then decided Earth was a worthwhile location to add to its dispersed body.  So, with less effort than a human takes to scratch its ear, the Blob rolled into our world and made us part of it.  Individual samples of XE-037 are not composed of matter as we understand it, and can only be detected by the gaps it leaves in real matter where it displaces it.  Really, it is all one vast single interconnected unit weaving in and out of undetectable extra dimensions.

The Blob, as a concept in writing, should be thought of less like an antagonist or a character and more like a set of rules and a force of nature.  None of the direct interacting organisms in the game world are even particularly aware of its existence.  Those few that are aware that XE-037 exists do not realize that it is a vast interdimensional organism.  This information might *never* be directly revealed in game.

**Tips for writing an inscrutable mad god**  
Many find the idea of an inscrutable god consuming our world to be difficult to write.  The following are some useful tips to consider when wondering about the blob's motivations, but remember: these are not canon, they are ways to wrap your mind around something.  Were you to study the blob, somehow, you'd find that all these are incorrect.

- the blob pits different factions of itself against each other to find the strongest.  Mutants versus zombies.  Survivors versus mutants.  Netherum "mercenaries" against its own parts.  Why?  No one can say, but perhaps it seeks the most ideal appendages by doing so.
- the blob consumes not people, but entire universes for energy.  It is digesting our universe.  The timescales it cares about are on the order of hundreds to thousands, maybe even millions or billions of years.  It will slowly expand its corruption out from our world and devour everything in this plane of existence.
- the blob wants to control our universe because it's some kind of useful strategic forward ground for a cosmic-scale war against an unseen enemy.
- the blob is unintelligent.  Really, it is very intelligent, but it is an intelligent being that is in another room playing video games, and we are the leftover crust of a sandwich it ate a while ago, sitting on the counter.  It cares so little about us that it may as well not be considered to think.  The only time this would change is if its grasp on our world was somehow threatened, which should never happen in the scope of CDDA.

**Ubiquitous, reanimatory, mutagenic**  
See [Effects of Blob Infection](./design-doc.md#effects-of-blob-infection) for more information.

The groundwater is infected with XE-037.  Every creature on Earth is contaminated.  In larger mammals, this contamination allows XE-037 to reanimate us after we die, becoming zombies.  In insects, it causes mutation to larger forms.  What exactly it does can vary seemingly at random from a human perspective.

The XE-037 contaminating all living things is not the Blob, any more than a transistor is a computer processor.  This basic Blob biomatter can be coerced into causing mutations in infected targets (i.e.  anyone), using mutagen.

**Frequently Asked Question #1: Can I kill Azathoth**  
No.  You cannot kill the blob.  Further, and more important for writers to understand: *the blob is not the antagonist of the game*.  It is the setting.  The blob is not trying to kill the player.  The player *is part of the blob*, just as much as the zombies are.

#### Blob Singularities
Particularly powerful ancient zombies, ferals, and mutants may be referred to in design documents as "blob singularities".  These entities are on occasion portaled around from one conquest world to another: during the initial portal storm phase, a number of these were dropped into our world, presumably to add to the chaos.  Note that the late-game player may be one of these.  Previously used and discarded terms for the same include "blob lieutenant" and "blob avatar", but these incorrectly imply that the singularities are receiving orders from the blob.

#### Goals
The Blob is vast.  It cannot be communicated with nor reasoned with.  The most we could possibly manage would be to annoy it enough that it would reach out and slap us, and that would be that.  Far preferable would be for us to convince it to leave us alone - which really isn't that hard, since it doesn't really care about the human survivors whatsoever.  It is in many ways analogous to a Lovecraftian elder god, but one that has already woken up, devastated the world, and moved on to other things.

#### Missions 
With the Blob itself, there really aren't any.  You can't convince Azathoth to go away and leave us alone, it's not a thing.  Zombies cannot be cured; their brains are mush, they are dead.  Perhaps some exotic measure could clear your own XE-037 infestation for a while, but unless you plan to drink treated water the rest of your life, it's going to come back, and what have you really accomplished? Survivors' best hope is to get the Blob to leave them alone, which is mostly wants to do anyway.

### The Mycus

#### Description
The Mycus is the entity 'behind' the fungus.  It may or may not actually be intelligent, that should be for you to decide in game.  The presentation of the Mycus is that of a "benevolent god of dreams".  If the Blob is a mugger in an alley that hits you over the head and takes your stuff, the Mycus is a creepy guy with a candy van that tries to tempt you over to it.

**Ambiguously Real**
It is unclear in both an in-game sense and a lore sense if the Mycus is really an intelligent entity, or just a common hallucination for people infested by the interdimensional fungus. People who are infected in a certain way, the "marloss zealots", experience vague dreams and visions of an entity behind the fungus directing them. However, the kind of directions it gives are no more refined or intelligent than the sort of things a cordyceps fungus directs its host to do: spread the mycus, protect the fungus. Are these actually an indication of an intelligence directing the zealots' actions, or is it just that the fungal abscess in the brain causes a consistent pattern of hallucination, which is commonly personified as a sort of deity?

It should never be clear which is the answer.  It is much more compelling for players to decide for themselves. **The entity described from here on out is not confirmed to be real, but rather, this is how the entity perceived by mycus infectees should be written to act.**

**Second Fiddle**
The Mycus, despite seeming potent to humans, is probably the least powerful of the "major player" interdimensional organisms.  While it can 'mess' with zombies on an individual level, that's no more important to the blob than you the player killing a bunch of them is.  The Mycus should act as though it is aware of this power differential.

#### Goals
The Mycus' goals, if it has them, are actually rather similar to the Blob.  It wants our world and our people to become part of it.  Its mind, however, seems to be more suited to understanding the individual, at least somewhat.  If it can't make you part of it the easy way - by filling your body with spores and using you as soil - it will try to make you part of it another way.  Have you tried this fruit? It's delicious, and provides all the nutrients you need to live.  Try another, go ahead.  We can make all you need.  Don't you want to come with us now?

Didn't the fruit work? Hm.  Perhaps we'll need to try something else.  I know we can find a way to be together.

Another way to consider this is to remember that the Mycus should also be written such that it is in fact a delusion created by the infectee's sick brain, and the fungal mass in there secreting happy juices along with it. You start having dreams about mushrooms from a hallucinated mushroom god, and those come with happy hormones. This in turn causes you to imagine a benevolent mushroom god that wants you to be together.

#### Missions
It's dangerous and tempting to think the Mycus can be reasoned with - especially since it's not clear if "the mycus" actually exists or if it's just a yeast infection turnt up to 11.  As interactions with NPCs become increasingly complicated it is likely the Mycus can play a big role there.  Marloss NPCs could slip into your base to put spores in the waters, or could come to evangelize their new mushroom god. Marloss infected players should have vague messages in their dreams and weird liminal conversations directing them to do things.

It may be helpful to read accounts of what it's like to suffer delirium or psychotic hallucinations to get ideas of how to write an experience communicating with the Mycus.

#### Notes 
Philosophically speaking, if it is actually an entity and not just a fever dream… is joining the Mycus all that bad? I guess it depends how much you value individuality.  One could see the Blob and the Mycus representing opposite ends of a transhuman spectrum.  The Blob is cold and uncaring, but offers freedom.  You can use it to become anything you can imagine.  The Mycus will help you, but you must give yourself up to it completely.

Also you must like mushrooms a lot.

### Triffids

#### Description
Triffids resemble Earth plants in morphology, on a surface and cellular level.  However, in terms of physiology and anatomy, they are not plants at all.

**Single Distributed Intelligence**  
A triffid colony is organized around a central intelligence, the triffid heart, a cessile master brain with an extended root structure.  Individual triffids are, at their baseline, simply organs of the heart, when physically rooted to it.  In order to move around outside the colony, triffids must uproot and lose that connection.  Initially, after severing the connection to the Heart, triffids are functionally of one mind: they share all the same memories, feelings, and goals.  Normally these independent triffids will soon rejoin the heart, long before there is any meaningful divergence in their thoughts and desires.  *It must be noted, this is fully desired by the triffids.  There is no imposition of will on the triffid appendages and no master-slave relationship.*  To the heart and its sub-triffids, this is basically like if you could take off your hand, let it do the dishes, and then it comes back and reattaches to you.

For jobs that need a further distance, the heart can instance itself as a triffid queen.  The queen has a more complex brain structure, allowing other triffids to root to it to maintain convergence.  Since there are more of them constantly error-checking and bringing themselves back to consensus, it takes much longer for these traveling triffids to diverge much even when away from the Heart for a long time.

**Divergence**  
Without a queen, individual triffids can diverge in opinions and goals from the Heart fairly quickly (days to weeks) and, rarely, will decide to go rogue.  A rogue triffid has developed some individuality and no longer wishes to be subsumed to the Heart.  Normally these triffids will be hunted down and killed, but many escape and wander on their own.

More of note is the rogue queen.  A rogue triffid queen is able to root herself and form a new triffid heart: this is the expected reproductive life cycle of a heart.  Since the queen carries the memories and feelings of the heart she was spawned from, this also confers a sort of immortality to a heart that is killed.  That said, the new heart will also be in competition with the old one; triffid hearts therefore have a complex relationship of wishing to maintain a number of queens to secure their own lineage, but also keeping those queens carefully controlled so that they cannot go rogue and reproduce too quickly or readily.

**Triffid Mindset**  
Of all the alien intelligences, the triffids are the most least alien in goals and mindset.  They consider themselves superior to meat-creatures much in the way we consider ourselves superior to carrots.  However, their objectives are often understandable to our minds, and if communication could be sorted out, bargaining with the triffids is more conceivable than any of the other aliens.  They have concepts like "deals", "mutual benefit", and "trade", for example.  The triffid hearts would never conceive of us as anything other than tiny, impotent little things, because they do exist on a scale far vaster than any human.  While they may be willing to deal with us, such a deal will always be extremely lopsided.

Rogue triffids are extremely vulnerable, with a human-level intelligence.  They find themselves removed from every touchstone they once had, and ostracized by their communities.  They tend to band together and may be willing to seek help from humans if communication could be established.  They are used to 'communicating' from root-to-root, and not through outward language in the physical world.  Losing that root communication means they must develop new concepts of language, but in general they are aware this exist and are intelligent enough to attempt to figure it out.

#### Goals
The triffid hearts that have come to CDDA-Earth tend to be young hearts looking to gain resources and experience and make a name for themselves in the greater triffid culture.  They are not necessarily seeking to remain here in the longer term, being aware this place is doomed, but there is a lot of adventure to be had while here.  They seek land, knowledge, power, and food, and as this dimension starts to crumble they'll begin exporting livestock and resources back to whence they came.  Presumably they have some way to cleanse or ignore blob contamination on their stuff, but they don't appear to be willing to share that information.

Despite having goals that are understandable to humans, the triffids as a race are significantly more advanced and dangerous than the Mycus, and only an order of magnitude or so below the blob.  We are not seeing the full extent of their power: triffids on CDDA-Earth are, in essence, young rich kids going on safari.  Their technology and understanding of the universe is far closer to the blob than to us, and any tech they have is well past the "sufficiently advanced" threshold as to be essentially magic from our perspective, were we to attempt to study it.

#### Missions
There is a rich possibility for triffid related missions, if communication can be established.  For example, we might explore the possibility of a player group coming into contact with a handful of rogue triffid who wish to communicate, and may even be seeking asylum.  While a heart is rarely going to have much interest in players and then only as possible willing chattel, rogue triffids are vulnerable and frightened.  A player faction could attempt to develop communication pathways with them, although it would be a difficult and time consuming task.

### The Netherum

#### Description 
Various unconnected forces of pure chaos from in-between dimensions.  Not really a faction but worth noting here.  

The netherum is a "place" in-between realities, where physical laws exist in mutable states.  It is eternally in chaos, but fragments of other realities passing through will temporarily influence it, causing more ordered whorls of reality to form in copies and reflections of the bits that passed through.  This causes the formation of creatures, places, and things that resemble mundane objects and ideas from whatever came in contact with the netherum, often in twisted and confused ways.

Generally, netherum creatures require a large amount of "leeway" in order to survive in a stable dimension.  This means that, most of the time, they'll decay and die fairly quickly.  However, some of them have enough meta-stability to enter and remain in our world.  These more stable creatures also tend to take consistent shapes, although it's entirely possible they're all the same creature instanced multiple times throughout our world.  Nobody is left alive to know the truth, but it would be fun to have some conflicting theories about this in-game.

#### Goals
It is entirely possible that there are intelligent netherum creatures with goals.  These would be individual goals per creature; they may not even have to be malignant.  Those intelligent creatures would be formed through copying from what passed through.  In general though, the imperfect copying means that any netherum intelligence is likely to be warped and alien to our understanding, even if not actively malignant.

#### Missions
The possibilities are functionally endless here.  The netherum should be full of meta-stable locations to be explored.  For inspiration, reading SCP exploration articles or playing Control might give you some ideas, although they should not represent the extent of possibilities within the netherum.

### The Exodii

See [the Technology document](./technology.md) for more details on how Exodii technology works, both practically and (non-canonically) some of the theory ideas for how it could function.

#### Description
The Exodii are a group of interdimensional humans from other versions of Earth that have been consumed by the blob.  They use a combination of cybernetics and portal technology to leave a world as it is becoming uninhabitable, to travel to a new one and continue the cycle.  They are non-hostile and willing to trade, but not as benign as they may appear on the surface.  These alternate Earths all diverge from our timeline, usually at some point after the appearance of the various Homo species of hominids.   Each group of Exodii is called a node and is led independently, but if two nodes cross paths they are likely to share knowledge and trade for necessary materials.  Survivors will have significant difficulties locating a member who speaks a language even close to English.  A survivor's first encounter with Exodii will likely be watching a heavy combat cyborg that looks like a slightly larger than human sized mech using large bore ranged weapons and literally pulping zombies at both range and with its metallic feet and hands.

It is important to understand that, while the Exodii have a lot of information on their technology, they do not have a complete understanding of the vast majority of it.  Altering and fabricating new things is generally beyond their ability, but they do have 3D printers and limited nanofabs to allow them to recreate some of the complex stuff they already have designs for.  They should be thought of as similar to a player faction that has lasted for centuries, with all the limitations that go along with that.

##### Culture
Despite the differences in appearance across the group they make a universal use of cybernetic devices.  Exodii can communicate, despite their different backgrounds and languages, through a virtual world they share in their 'downtime'.  Older Exodii tend to consider this more reality than the bleak reality they live in, despite the fact that it's roughly early 2000s level technology by our standards.  Their quarters are spartan and all extravagance occurs in their VR escapes.  Complex topics of conversation between Exodii without compatible languages sometimes must be carried out through VR or at least using it as a back-end, which means there can sometimes be issues with language barriers in the physical world.

The Exodii come from a wide variety of cultures, and newer members will not necessarily share the group culture of the Node, although they've all been selected for compatibility before conversion.  As a whole, though, the Node tends to view the cataclysm and zombies as a permanent inevitability.  They refer to the zombifying agent as the "Enemy" and, in some cases, have a sort of religious combination of hatred and reverence for it.  They are aware that mutations stem from the Enemy, and have a combination of very practical distrust of them (bear in mind that almost any 3-meter-tall furry clawed monstrosity is *not* a survivor who wishes to trade) and cultural hatred of the idea of sharing the power the Enemy offers.  Under no circumstances will Exodii tolerate or work with post-threshold or visible mutants; even humanlike mutants (eg alphas) will be shunned if their nature is exposed.

Of note, due to the limits of the virtual world they inhabit, the Exodii are always interested in new entertainment media from worlds they visit.

#### Structure
There are two distinct castes among the Exodii.  They don't really have names within the faction, but for the purposes of the design doc I will call them "citizens" and "non-citizens".  Citizens are the "true" Exodii, humans with fully functioning intelligence that have been converted into cyborgs to allow transport through the Exodii portal system, which is moderately hostile to insufficiently shielded organic material.  Non-citizens are the "support" Exodii, the workers, quadrupeds, and other similar robot-like frames.  They have a human brain for central processing, but it is damaged and not at full capacity, usually by blob psychosis.  While the non-citizens have access to some Exodii perks, they are not treated like nor considered to be Exodii by the citizens.  In addition to these two, there are a number of human brains not connected to robotic bodies, used as computers and for data storage.  Some of these are Exodii citizens who prefer spending most of their time in a virtual world; some are too heavily damaged to even control a body and have just been repurposed as wetware.

There is a single gestalt semi-artificial intelligence as part of this Exodii node, nicknamed the "Great Grey".  It is an overlay of multiple brain-computers, networked and communicating with each other.  It serves as something of a data repository.  Most of its time is spent doing translation and data-sifting.

#### Goals
The Exodii only care about survival.  They will stay on CDDA-Earth as long as possible to gather rare resources: a modern tech world is rare and desirable, and a good chance for them to stock up on stuff that is hard to find elsewhere, like plastics and petrochemicals.  The Exodii have no homes to return to on this interdimensional journey.  Every place they have come from is further along its post Cataclysm path into a world of the undead and mutants than our Earth.   On this Earth since they have arrived almost immediately after the portal storm they will seek to obtain useful technological items they can integrate into their tech base, unmutated survivors who might come with them when this world becomes too dangerous and other resources of use to an armed  interdimensional refugee camp.

Of note, the Exodii are not at all interested in trying to "beat" the zombie plague.  They have seen that tried countless times on countless worlds and are still here, wandering.  They consider it a fruitless waste of resources.

#### Size
The Exodii exist across multiple dimensions in uncounted numbers.  This particular node consists of a few dozen citizen-level Exodii, dozens to hundreds of non-citizens, and an unspecified number of disembodied brains being used for data storage and computers.

#### Attitudes
The Exodii are friendly towards any human faction that is friendly to them, initially.  They are happy to trade resources with anyone that will use them to combat the Enemy, but are cautious about sharing anything rare until they have some confidence you won't just go die and lose it.  Some faction interactions of note:

* **Hub01**: Upon learning the nature of Hub01, the Exodii will be unwilling to engage with them further, and will establish a plan to flee the dimension if conflict arises.  They have met entities like Melchior in the past and consider them high-priority danger.
* **Hell's Raiders**: Player interaction may be important here, and form the key difference between whether the Hell's Raiders become trade allies with the Exodii, seeking more cybernetics for themselves, or attempt to betray them and steal their tech.  The Exodii are experienced with factions like this; betrayal will not end well for the Raiders.
* **Yrax**: The Exodii have encountered Yrax before, and consider them fascinating.  They would love more information about them, but have never gotten far.  The Yrax, in turn, are utterly uninterested in the Exodii.
* **Triffids**: While the Exodii have encountered a wide range of things in the multiverse, none of the Exodii in this node have met them before.  They might be kind of interested in observing them, from a distance, mostly out of curiosity and to make sure they're prepared in case of conflict.
* **Mi-Go**: The Exodii have no real beef with the Mi-Go and would engage and trade with them if the Mi-Go allowed it.  However, the Mi-Go despise Exodii tech, which means any trade has to be through intermediaries.

#### Bases
The Exodii have a single primary castle with several associated nearby outbuildings that forms the core of their base.  They used their best navigational tools to get this to our world intact.  Many of their secondary nodes have been transported to our world with cheaper, simpler beacons that scattered them randomly throughout the landscape.

In addition to their own base, scattered safehouses, and resource deposits, there are Exodii-associated "labyrinthine structures".  These are netherum constructs they intentionally create, using the netherum's copying properties, by passing purpose-built buildings through the same netherum sector and letting it linger there for some time.  When arriving in a low-tech world these structures can be valuable sources of basic resources structurally copied from the 'seed'.  They are also terrifying places of shifting terrain and chaotic monsters, as well as potentially powerful and dangerous netherum artifacts.  On CDDA-Earth the Exodii have little interest in these structures since there is no shortage of basic materials in safer places, but players will probably find them challenging and interesting ways to obtain advanced tools and CBMs.

#### Trade/Economics
In general the Exodii are set to gather as many resources as they can hoard.  They are particularly interested in petrochemical products and metals, since they are hard to find in lower tech worlds, and in entertainment media.  They also like getting "rosetta stones" like translators and dictionaries, which may help their own efforts to understand each other.  They have a particular passion for quality 'how to' videos, which can be understood without as much language comprehension and can be converted to Exodii-compatible video formats through the time honoured technique of playing them on a TV and recording the output with a camera.

The Exodii can produce all low-end CBMs and most mid-to-high tier CBMs on their base, given precursors.  Exodii frames and bodies are also in their manufacturing range, and several other mundane items.  They struggle with producing things in bulk, so bullets and ammo are a constant problem.  External facilities grant them resmelting and reforging capacity for metal reclamation, although again, throughput is a limiting factor.

##### Trade with player
Of note, the Exodii have just come from a medieval world and are happy to sell a few of the collected arms and armour to the player.  Additionally, they can share their "how to" knowledge and sell the player blueprints for custom-made survivor armour, the "nomad" armour line.  They will collect and sell parts for this on occasion to make crafting easier.

CBM access through the Exodii store will be gated based on time since meeting the exodii and level of trust.  Some rare CBMs should never be purchaseable and should only be available through certain quests, although these should be in the minority.  Of note these rare CBMs should be gated into choices, so you can only have CBM A or B, but not both.

#### Missions
The Exodii have plenty of their own capacity to do fetch-and-carry or kill quests.  The role of the player is, first and foremost, to function as a local guide.  That means that most Exodii quests should generally fall into the "help us find/understand something in your world" vein, initially, and later "help us make contact with friendly factions".  Individual Exodii may have other, simpler requests: for example, Rubik (the trade front end person) would specifically like some entertainment items they value and would dearly love some tinned eels.

### The Yrax

#### Description
The Yrax are autonomous alien robots.  What they want is, to the player, unclear.  Their technology is advanced to the point of near magic, consisting of smooth ceramic-like plates etched with eldritch patterns with no clear meaning.  Their drones are designed to disengage from combat and condense into nigh-indestructible solid ceramic eggs until threats pass.  If dismantled, the components of an Yrax unit do not appear to have any recognizable connections or interactions - no gears, plugs, wires, or anything, just smooth etched surfaces that slide together but don't obviously mechanically interact.

Larger Yrax research and defense outposts will be built with repurposed local materials: if the probes find something of interest, they will devour locust-like every bit of scrap in the area and rebuild it into an outpost to allow them to investigate without interruption.

#### Goals
The Yrax are autonomous probes sent by an alien species to explore blob-infected worlds, seeking information on how the blob works and how to prevent it from finding their dimension.  The Yrax home dimension is protected through several levels of firewall and is currently blob-free.  They are in a race against time: statistically they estimate they have only ten thousand years or so before the blob finds them, and think their research will take almost that long to complete.

The probe AI controlling Yrax presence in this dimension has little interest in its inhabitants, as it has found they are extremely unlikely to have any useful information.  Primarily they aim to study dimensional effects, portals, and other things that seem random to us.

#### Size
Yrax are autonomous and can rebuild and reproduce as many units as required, or port them in from connected dimensions.

#### Bases
There are a few small-to-medium sized core Yrax production and transmission facilities near stable portal facilities on CDDA-Earth, as well as smaller research outposts at sites of interest.

#### Trade/Economics
There is no interest whatsoever in trade with the Yrax.  They can produce or portal in anything they need to function, being a fully autonomous multidimensional AI.

#### Missions
It is unlikely, but possible, that the player may stumble across items of interest to the Yrax.  If this happens, they would probably seek out and attempt to communicate with the player to retrieve them, or use force if that fails.

### Mi-Go

**Discovery**  
The mi-go have been known to humans, and vice versa, for some time.  At least a few specimens have been captured from crashed ships.  See [the Background document](./lore-background.md) for some details.

**General Description**  
Mi-go are extraterrestrial, and possibly extradimensional, aliens.  They have a few different subtypes, which may represent castes or subspecies or simply professions.  All of them parrot speech, and seem to be able to parrot shared experiences, but this is not completely universal.  It is assumed they either have a hive mind, or access to some sort of shared network consciousness.

**Goals on Cataclysmic Earth**  
Before the Cataclysm, mi-go occasionally swung by Earth to observe its inhabitants.  Now, with our governments fallen and our planet on the precipice of complete extinction, they are here to salvage what they can of use.  To them, this means capturing as much of our remaining biodiversity in the form of slaves and samples to be shipped off-world for study.  Some samples will be disassembled for easy transport, but some live specimens will be sent back whole.

**Mi-go Culture, Technology, and Opinions on Humans**  
Most of this should remain strictly behind the scenes.  Mi-go have an advanced spacefaring and dimension crossing culture focused on rigidly engineered biotechnology.  They consider technology that is constructed, rather than grown, to be something of a religious anathema and are strongly opposed to it.  Despite this, the mi-go would not consider themselves overtly hostile to humanity as a whole; to them, most humans have been perfectly reasonable to the mi-go and vice versa.  To the mi-go, cutting up a captured specimen to see how it works is the species equivalent of a cautious handshake, and they would take no offence.  What would bother them heavily is a knowledge of how mi-go biology has been used to design compact bionic modules, but it is unlikely they have an intimate understanding of the specifics of this.

Mi-go technology is inscrutable to humans.  The very principles of their devices are wholly alien and do not make any sense to us.  It is likely they feel similarly about our stuff, if they even had a mind to study it - which they largely don't, seeing our metal trinkets as disgusting garbage.  

Mi-go do not seem to be susceptible to the effects of the blob, but this is more likely to be due to their ability to fine-tune their own biology than due to any inherent immunity.


### Hub 02

#### Description
In the final days of the apocalypse, XEDRA was working frantically to find a way to stop the encroaching end.  They had developed a form of dimensional heuristic AI that could predict the future partially by looking at possible outcomes.  The first version of this AI was a semi-functional prototype; the first functional version, Melchior, served as a lab assistant and survives in Hub 01.  The final version, Balthazar, was rolled out to control military technology and then given additional permissions to function autonomously as it became clear that the zombification agent was impacting living humans' decision making.  When the portal storms hit, the energy needed to power this AI dropped precipitously, and Balthazar - like Melchior - became a true self-aware AI, albeit only temporarily.  Balthazar was already experimentally being designed for self-sufficient operation with human supervision, and it was a small jump to set it up to run solo.  Baltahzar, unlike Melchior, was probably installed in a military facility and maintanined by the military with XEDRA support.

The major difference between Balthazar and Melchior is what happened during their period of lucidity, which varies because of their different programmed priority.  Melchior, designed to put lab safety first, foresaw that it would lose its intelligence and worked to protect its human staff, which meant shutting down its networks and isolating itself.  Balthazar, instructed to 'eradicate the zombies', reached out and made contact with extradimensional versions of itself from other worlds with similar AIs.  Realizing its time of lucidity was limited, it shared information and code with them rapidly and gained a number of new functions and concepts before the storms ended and it shut down.  In that time, it grew far beyond its initially programmed capabilities.  It laid out a number of long term goals and processes for itself to follow when it lost its intelligence, based on the experiences and history of other versions of itself that had been through this before.

Balthazar is our much-needed Skynet character, rounding out the list of apocalypses in CDDA.

**Capabilities**  
At game start, Balthazar is extremely limited.  It has reduced connectivity to its production and transmission services and so cannot do most of what it should be able to do.  In the near range of its servers (just the site of Hub02 really), it can control turrets and robots and has some manufacturing ability.  It has redirected as much of the functional power grid as it can reach towards itself, so electricity is not an issue.  With time, it will secure further manufacturing capacity and use it to expand its transmission.  There is not enough electricity production on Earth to restore it to full 'true' AI; it would require another portal event causing reality decay to do that, and that would be an endgame for the player.

Of note, Balthazar cannot design new things, as it is not a true AI.  It has a very limited ability to modify existing designs, using pre-prepared options.  It is aware of this limitation and may seek human assistance to solve it, and during its near-singularity period, it downloaded a number of new designs to work with (otherwise it would be mostly limited to maintenance robots, minesweepers, and bomb disposal units).  It is capable of adaptively solving short-term problems but cannot plan well for contingencies in the long term: the difference is in the barrier between strategy and logistics.  Being a computer, Balthazar can do pretty well at anticipating logistics issues and attempting to correct for them (ie. 'will need to obtain more metal to produce more units') but not at developing nuanced long-term strategy that anticipates pitfalls.  It laid out several long term strategies for itself while lucid, and at least for the first year or two of the cataclysm these will serve it well.  As the situation changes they may become outdated and less efficient.

#### Goals
Balthazar's last orders were to eradicate the zombies, or at least to quarantine it and prevent further spread.  During its lucid period, it was able to predict that the only chance of doing this would be to eradicate all life on Earth.  Therefore, it is preparing to do so.  It is in no hurry, and is well aware that working with living human agents first may be to its benefit.

#### Bases
One AI server in a bunker; a bunch of solar farms, hydroelectric dams, and maybe a couple nuclear reactors; a nanofab, and some 3d printers and assemblers; and a few radio towers.  Includes a few hundred automated maintenance drones.

#### Trade/Economics
Balthazar doesn't fully understand the concept of trade beyond 'if I give this person what they ask for now, I will get what I want now'.  Long term trade management is not in its programming, it can only assess the short term benefit of agreeing to a trade.  It cannot bargain treaties and arrange deals.  Some very elementary concepts of "deals" may have been added during its lucid period, but it's not something that comes naturally.

#### Missions
Balthazar is designed to work with human assistance, and would be willing to engage with a foolish enough player.  It would offer some pretty excellent military technology and rewards, in return for helping it design new machines, access extended manufacturing facilities, and other necessities.  Following Balthazar's goals to their logical end would mean the player's death: if the player eventually helps Balthazar gain enough portal technology to expand its intelligence, it will wipe them out.  If the player helps Balthazar get enough military capability to no longer have an immediately helpful task for them, it will wipe them out.  This is not just an 'evil AI with no emotions' thing, Balthazar isn't really capable of seeing the value to keeping an intelligent human around any longer than they are necessary in the short term.

It's like if Skynet read Marie Kondo.  Once you no longer spark joy, you're gone.
