/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.Icon;

public class ColoredIcon
implements Icon {
    private Icon sourceIcon;
    private Color tint;
    private float alpha;

    public ColoredIcon(Icon source, Color tint, float alpha) {
        this.sourceIcon = source;
        this.tint = tint;
        this.alpha = alpha;
    }

    public ColoredIcon(Icon source, Color tint) {
        this.sourceIcon = source;
        this.tint = tint;
        this.alpha = 0.5f;
    }

    @Override
    public int getIconHeight() {
        return this.sourceIcon.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        return this.sourceIcon.getIconWidth();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        BufferedImage img = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics2D g2 = (Graphics2D)img.getGraphics();
        this.sourceIcon.paintIcon(c, g2, 0, 0);
        g2.setComposite(AlphaComposite.getInstance(10, this.alpha));
        g2.setColor(this.tint);
        g2.fillRect(0, 0, this.getIconWidth(), this.getIconHeight());
        g2.dispose();
        g.drawImage(img, x, y, null);
    }
}

