/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.TablePane;
import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.ChangeListeningDataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelChangeUtil;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;

public class ColumnMappingPanel
extends ChangeListeningDataEntryPanel
implements SPListener {
    private static final Logger logger = Logger.getLogger(ColumnMappingPanel.class);
    private final ArchitectSwingSession session;
    private final SQLRelationship r;
    private final TablePane lhsTable;
    private final TablePane rhsTable;
    private int gap = 100;
    private int handleLength = 20;
    private final CustomPanel panel = new CustomPanel();
    private final JScrollPane scrollPane;
    private boolean modified = false;
    private Map<SQLColumn, SQLColumn> mappings = new HashMap<SQLColumn, SQLColumn>();
    private Color otherRelColour = Color.RED;

    public ColumnMappingPanel(ArchitectSwingSession session, SQLRelationship r) {
        this.session = session;
        this.r = r;
        PlayPen pp = new PlayPen(session);
        this.lhsTable = new TablePane(r.getPkTable(), pp.getContentPane());
        this.rhsTable = new TablePane(r.getFkTable(), pp.getContentPane());
        pp.getContentPane().addChild((SPObject)this.lhsTable, 0);
        pp.getContentPane().addChild((SPObject)this.rhsTable, 0);
        SQLPowerUtils.listenToHierarchy((SPObject)((SQLTable)this.lhsTable.getModel()).getParent(), (SPListener)this);
        pp.destroy();
        this.lhsTable.setLocation(1, 1);
        this.rhsTable.setLocation(this.lhsTable.getWidth() + this.gap, 1);
        this.updateMappingsFromRelationship();
        MouseHandler mouseHandler = new MouseHandler();
        this.panel.addMouseListener(mouseHandler);
        this.panel.addMouseMotionListener(mouseHandler);
        this.scrollPane = new JScrollPane(this.panel);
        this.colourOtherRelationships();
    }

    private void colourOtherRelationships() {
        try {
            SQLTable t = (SQLTable)this.rhsTable.getModel();
            for (SQLRelationship.SQLImportedKey k : t.getImportedKeys()) {
                SQLRelationship r = k.getRelationship();
                if (r == this.r) continue;
                for (SQLRelationship.ColumnMapping cm : r.getChildren(SQLRelationship.ColumnMapping.class)) {
                    this.rhsTable.addColumnHighlight(cm.getFkColumn(), this.otherRelColour);
                }
            }
        }
        catch (SQLObjectException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void updateRelationshipFromMappings() throws SQLObjectException {
        try {
            this.r.begin("Modify Column Mappings");
            logger.debug((Object)"Removing all mappings from relationship...");
            for (int i = this.r.getChildren(SQLRelationship.ColumnMapping.class).size() - 1; i >= 0; --i) {
                this.r.removeChild((SPObject)this.r.getChildren(SQLRelationship.ColumnMapping.class).get(i));
            }
            for (Map.Entry<SQLColumn, SQLColumn> entry : this.mappings.entrySet()) {
                logger.debug((Object)("Adding mapping " + entry.getKey() + " -> " + entry.getValue()));
                this.r.addMapping(entry.getKey(), entry.getValue());
            }
            this.r.commit();
        }
        catch (IllegalArgumentException e) {
            this.r.rollback("Could not remove mappings: " + e.getMessage());
            throw new RuntimeException(e);
        }
        catch (ObjectDependentException e) {
            this.r.rollback("Could not remove mappings: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void updateMappingsFromRelationship() {
        this.mappings = new HashMap<SQLColumn, SQLColumn>();
        for (SQLRelationship.ColumnMapping cm : this.r.getChildren(SQLRelationship.ColumnMapping.class)) {
            this.mappings.put(cm.getPkColumn(), cm.getFkColumn());
        }
        this.panel.repaint();
    }

    public boolean applyChanges() {
        try {
            this.cleanup();
            this.updateRelationshipFromMappings();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void discardChanges() {
        try {
            this.cleanup();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JComponent getPanel() {
        return this.scrollPane;
    }

    public boolean hasUnsavedChanges() {
        return this.modified;
    }

    private void cleanup() throws IllegalArgumentException, ObjectDependentException {
        SQLPowerUtils.unlistenToHierarchy((SPObject)((SQLTable)this.lhsTable.getModel()).getParent(), (SPListener)this);
        this.lhsTable.getParent().removeChild((SPObject)this.lhsTable);
        this.rhsTable.getParent().removeChild((SPObject)this.rhsTable);
    }

    public void childAdded(SPChildEvent e) {
        this.panel.repaint();
        if (e.getSource() instanceof SQLTable && (e.getChild() instanceof SQLRelationship || e.getChild() instanceof SQLRelationship.SQLImportedKey)) {
            TablePane tp;
            if (this.lhsTable.getModel() == e.getSource()) {
                tp = this.rhsTable;
            } else if (this.rhsTable.getModel() == e.getSource()) {
                tp = this.lhsTable;
            } else {
                return;
            }
            this.updateMappingsFromRelationship();
            tp.setBackgroundColor(DataEntryPanelChangeUtil.NONCONFLICTING_COLOR);
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        } else if (e.getChild() instanceof SQLRelationship.ColumnMapping) {
            SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)e.getChild();
            for (TablePane tp : new TablePane[]{this.lhsTable, this.rhsTable}) {
                for (SQLColumn c : new SQLColumn[]{cm.getPkColumn(), cm.getFkColumn()}) {
                    try {
                        if (!((SQLTable)tp.getModel()).getColumns().contains(c)) continue;
                        this.updateMappingsFromRelationship();
                        tp.addColumnHighlight(c, DataEntryPanelChangeUtil.DARK_NONCONFLICTING_COLOR);
                        this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
                    }
                    catch (SQLObjectException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    public void childRemoved(SPChildEvent e) {
        this.panel.repaint();
        if (e.getSource() instanceof SQLTable && (e.getChild() instanceof SQLRelationship || e.getChild() instanceof SQLRelationship.SQLImportedKey)) {
            TablePane tp;
            if (this.lhsTable.getModel() == e.getSource()) {
                tp = this.rhsTable;
            } else if (this.rhsTable.getModel() == e.getSource()) {
                tp = this.lhsTable;
            } else {
                return;
            }
            this.updateMappingsFromRelationship();
            tp.setBackgroundColor(DataEntryPanelChangeUtil.NONCONFLICTING_COLOR);
            this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
        } else if (e.getChild() instanceof SQLRelationship.ColumnMapping) {
            SQLRelationship.ColumnMapping cm = (SQLRelationship.ColumnMapping)e.getChild();
            for (TablePane tp : new TablePane[]{this.lhsTable, this.rhsTable}) {
                for (SQLColumn c : new SQLColumn[]{cm.getPkColumn(), cm.getFkColumn()}) {
                    try {
                        if (!((SQLTable)tp.getModel()).getColumns().contains(c)) continue;
                        this.updateMappingsFromRelationship();
                        tp.addColumnHighlight(c, DataEntryPanelChangeUtil.DARK_NONCONFLICTING_COLOR);
                        this.setErrorText("<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>");
                    }
                    catch (SQLObjectException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }
        }
    }

    public void propertyChanged(PropertyChangeEvent e) {
        this.panel.repaint();
    }

    public void transactionEnded(TransactionEvent e) {
    }

    public void transactionRollback(TransactionEvent e) {
    }

    public void transactionStarted(TransactionEvent e) {
    }

    private class MouseHandler
    implements MouseListener,
    MouseMotionListener {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            try {
                Map.Entry<SQLColumn, SQLColumn> entry = ColumnMappingPanel.this.panel.mappingForFkHandleAt(e.getPoint());
                if (entry != null) {
                    ColumnMappingPanel.this.panel.setDraggingHandle(entry.getValue());
                    ColumnMappingPanel.this.panel.setDraggingPoint(e.getPoint());
                } else {
                    ColumnMappingPanel.this.panel.setDraggingHandle(null);
                    ColumnMappingPanel.this.panel.setDraggingPoint(null);
                }
            }
            catch (SQLObjectException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            try {
                if (ColumnMappingPanel.this.panel.getDraggingHandle() == null) {
                    return;
                }
                SQLColumn oldFkCol = ColumnMappingPanel.this.panel.getDraggingHandle();
                Point p = e.getPoint();
                int newFkColIdx = ColumnMappingPanel.this.rhsTable.pointToItemIndex(new Point(0, p.y));
                if (newFkColIdx >= 0 && newFkColIdx < ((SQLTable)ColumnMappingPanel.this.rhsTable.getModel()).getColumns().size()) {
                    SQLColumn newFkCol = ((SQLTable)ColumnMappingPanel.this.rhsTable.getModel()).getColumn(newFkColIdx);
                    if (ColumnMappingPanel.this.mappings.containsValue(newFkCol)) {
                        return;
                    }
                    Map.Entry oldEntry = null;
                    for (Map.Entry entry : ColumnMappingPanel.this.mappings.entrySet()) {
                        if (entry.getValue() != oldFkCol) continue;
                        oldEntry = entry;
                        break;
                    }
                    if (oldEntry == null) {
                        throw new IllegalStateException("Couldn't find existing mapping at end of drag operation!");
                    }
                    SQLColumn pkCol = (SQLColumn)oldEntry.getKey();
                    ColumnMappingPanel.this.mappings.remove(pkCol);
                    ColumnMappingPanel.this.mappings.put(pkCol, newFkCol);
                    ColumnMappingPanel.this.modified = true;
                }
            }
            catch (SQLObjectException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                ColumnMappingPanel.this.panel.setDraggingHandle(null);
                ColumnMappingPanel.this.panel.setDraggingPoint(null);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ColumnMappingPanel.this.panel.getDraggingHandle() != null) {
                ColumnMappingPanel.this.panel.setDraggingPoint(e.getPoint());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class CustomPanel
    extends JPanel {
        private SQLColumn draggingHandle;
        private Point draggingPoint;

        CustomPanel() {
            this.setBackground(Color.WHITE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            boolean antialias = ColumnMappingPanel.this.session.getContext().getUserSettings().getSwingSettings().getBoolean("SwingUserSettings.PLAYPEN_RENDER_ANTIALIASED", false);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            super.paintComponent(g2);
            ColumnMappingPanel.this.lhsTable.paint(g2);
            g2.translate(ColumnMappingPanel.this.rhsTable.getX(), ColumnMappingPanel.this.rhsTable.getY());
            ColumnMappingPanel.this.rhsTable.paint(g2);
            g2.translate(-ColumnMappingPanel.this.rhsTable.getX(), -ColumnMappingPanel.this.rhsTable.getY());
            try {
                SQLTable pkTable = (SQLTable)ColumnMappingPanel.this.lhsTable.getModel();
                SQLTable fkTable = (SQLTable)ColumnMappingPanel.this.rhsTable.getModel();
                int ncols = pkTable.getColumns().size();
                for (int colidx = 0; colidx < ncols; ++colidx) {
                    SQLColumn pkCol = pkTable.getColumn(colidx);
                    SQLColumn fkCol = (SQLColumn)ColumnMappingPanel.this.mappings.get(pkCol);
                    if (fkCol == null) continue;
                    int pky = ColumnMappingPanel.this.lhsTable.columnIndexToCentreY(colidx);
                    int fky = ColumnMappingPanel.this.rhsTable.columnIndexToCentreY(fkTable.getColumnIndex(fkCol));
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Drawing Line from " + pkTable.getColumn(colidx).getName() + " (y=" + pky + ")" + " to " + fkCol.getName() + " (y=" + fky + ")"));
                    }
                    if (fkCol == this.draggingHandle) {
                        Point offsetDragPoint = new Point(this.draggingPoint.x - ColumnMappingPanel.this.handleLength / 2, this.draggingPoint.y);
                        g2.setColor(Color.RED);
                        g2.drawLine(ColumnMappingPanel.this.lhsTable.getX() + ColumnMappingPanel.this.lhsTable.getWidth(), ColumnMappingPanel.this.lhsTable.getY() + pky, offsetDragPoint.x, offsetDragPoint.y);
                        g2.fillRect(offsetDragPoint.x, offsetDragPoint.y - 1, ColumnMappingPanel.this.handleLength, 3);
                        g2.setColor(this.getForeground());
                        continue;
                    }
                    g2.drawLine(ColumnMappingPanel.this.lhsTable.getX() + ColumnMappingPanel.this.lhsTable.getWidth(), ColumnMappingPanel.this.lhsTable.getY() + pky, ColumnMappingPanel.this.rhsTable.getX() - ColumnMappingPanel.this.handleLength, ColumnMappingPanel.this.rhsTable.getY() + fky);
                    g2.fillRect(ColumnMappingPanel.this.rhsTable.getX() - ColumnMappingPanel.this.handleLength, ColumnMappingPanel.this.rhsTable.getY() + fky - 1, ColumnMappingPanel.this.handleLength, 3);
                }
            }
            catch (SQLObjectException ex) {
                throw new RuntimeException(ex);
            }
        }

        public Map.Entry<SQLColumn, SQLColumn> mappingForFkHandleAt(Point p) throws SQLObjectException {
            int colIdx;
            SQLTable fkTable = (SQLTable)ColumnMappingPanel.this.rhsTable.getModel();
            List fkCols = fkTable.getColumns();
            if (p.x < ColumnMappingPanel.this.rhsTable.getX() && p.x > ColumnMappingPanel.this.rhsTable.getX() - ColumnMappingPanel.this.handleLength && (colIdx = ColumnMappingPanel.this.rhsTable.pointToItemIndex(new Point(0, p.y - ColumnMappingPanel.this.rhsTable.getY()))) >= 0 && colIdx < fkCols.size()) {
                for (Map.Entry<SQLColumn, SQLColumn> entry : ColumnMappingPanel.this.mappings.entrySet()) {
                    if (entry.getValue() != fkCols.get(colIdx)) continue;
                    return entry;
                }
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(ColumnMappingPanel.this.rhsTable.getX() + ColumnMappingPanel.this.rhsTable.getWidth(), Math.max(ColumnMappingPanel.this.lhsTable.getHeight(), ColumnMappingPanel.this.rhsTable.getHeight()));
        }

        public void setDraggingHandle(SQLColumn newHandle) {
            if (newHandle != this.draggingHandle) {
                this.draggingHandle = newHandle;
                logger.debug((Object)("DraggingHandle changed to " + this.draggingHandle));
                this.repaint();
            }
        }

        public SQLColumn getDraggingHandle() {
            return this.draggingHandle;
        }

        public void setDraggingPoint(Point point) {
            this.draggingPoint = point;
            this.repaint();
        }
    }
}

